/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.cache;

import com.lenovo.vctl.dal.cache.Cache;
import com.lenovo.vctl.dal.cache.CacheFactory;
import com.lenovo.vctl.dal.cache.impl.LocalCacheImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.CacheManager;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LocalCacheFactory
implements CacheFactory {
    private static Logger logger = Logger.getLogger(LocalCacheFactory.class);
    private static CacheFactory instance;
    private static Map<String, Cache> cacheMap;
    private CacheManager manager = CacheManager.getInstance();

    static {
        cacheMap = new ConcurrentHashMap<String, Cache>();
    }

    @Override
    public Cache getCache(String name) {
        if (StringUtils.isEmpty((String)name)) {
            logger.error((Object)"cache must have name!");
            return null;
        }
        Cache cache = cacheMap.get(name);
        if (cache == null) {
            if (!this.manager.cacheExists(name)) {
                this.manager.addCache(name);
            }
            net.sf.ehcache.Cache ehCache = this.manager.getCache(name);
            cache = new LocalCacheImpl(ehCache, name);
            cacheMap.put(name, cache);
        }
        return cache;
    }

    private LocalCacheFactory() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LocalCacheFactory.this.manager.shutdown();
                logger.info((Object)"LocalCacheFactory instance shutdown");
            }
        });
    }

    @Override
    public Cache getCache(String name, boolean isDynamic) {
        return this.getCache(name);
    }

    @Override
    public void removeCache(String name) {
        if (StringUtils.isEmpty((String)name)) {
            logger.error((Object)"cache must have name!");
        }
        if (cacheMap.containsKey(name)) {
            cacheMap.remove(name);
        }
        if (this.manager.cacheExists(name)) {
            this.manager.removeCache(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheFactory getInstance() {
        if (instance != null) return instance;
        Class<LocalCacheFactory> clazz = LocalCacheFactory.class;
        synchronized (LocalCacheFactory.class) {
            if (instance != null) return instance;
            instance = new LocalCacheFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

