/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.host.rmi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;

class RMISocketFactoryImpl
extends RMISocketFactory {
    private int clientTimeout;
    private SocketFactory factory;
    private ServerSocketFactory serverSocketFactory;
    private String host = null;

    public RMISocketFactoryImpl(int clientTimeout) {
        this.clientTimeout = clientTimeout;
        this.factory = SocketFactory.getDefault();
        this.serverSocketFactory = ServerSocketFactory.getDefault();
    }

    public RMISocketFactoryImpl(String host, int clientTimeout) {
        this(clientTimeout);
        this.host = host;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = this.factory.createSocket(host, port);
        socket.setSoTimeout(this.clientTimeout);
        return socket;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        if (this.host == null) {
            return this.serverSocketFactory.createServerSocket(port);
        }
        return this.createServerSocket(this.host, port);
    }

    public ServerSocket createServerSocket(String host, int port) throws IOException {
        InetAddress[] addresses = InetAddress.getAllByName(host);
        if (addresses == null || addresses.length != 1) {
            return this.serverSocketFactory.createServerSocket(port);
        }
        ServerSocket socket = this.serverSocketFactory.createServerSocket(port, -1, addresses[0]);
        return socket;
    }
}

