/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.rmi.provider;

import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

public class RemoteInterfaceGenerator {
    private static final Map<Class<?>, Class<? extends Remote>> remoteInterfaces = Collections.synchronizedMap(new WeakHashMap());

    private static byte[] generateRemoteInterface(Class<?> serviceInterface) {
        Method[] methods;
        String interfazeName = serviceInterface.getName();
        ClassWriter cw = new ClassWriter(1);
        cw.visit(49, 1537, interfazeName.replace('.', '/'), null, "java/lang/Object", new String[]{"java/rmi/Remote"});
        StringBuffer argsAndReturn = null;
        for (Method method : methods = serviceInterface.getMethods()) {
            argsAndReturn = new StringBuffer("(");
            Class<?>[] paramTypes = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            for (Class<?> paramType : paramTypes) {
                argsAndReturn.append(Type.getType(paramType));
            }
            argsAndReturn.append(")");
            argsAndReturn.append(Type.getType(returnType));
            cw.visitMethod(1025, method.getName(), argsAndReturn.toString(), null, new String[]{"java/rmi/RemoteException"});
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    public static Class<? extends Remote> generate(Class<?> javaInterface) {
        if (!Remote.class.isAssignableFrom(javaInterface)) {
            Class<Remote> remote = remoteInterfaces.get(javaInterface);
            if (remote == null) {
                RemoteInterfaceClassLoader classloader = new RemoteInterfaceClassLoader(javaInterface.getClassLoader());
                byte[] byteCode = RemoteInterfaceGenerator.generateRemoteInterface(javaInterface);
                javaInterface = classloader.defineClass(javaInterface.getName(), byteCode);
                remote = javaInterface;
                remoteInterfaces.put(javaInterface, remote);
            }
            return remote;
        }
        return javaInterface;
    }

    static class RemoteInterfaceClassLoader
    extends ClassLoader {
        public RemoteInterfaceClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> defineClass(String name, byte[] byteArray) {
            return this.defineClass(name, byteArray, 0, byteArray.length);
        }
    }
}

