/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.rmi.provider;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.oasisopen.sca.ServiceRuntimeException;
import scallop.sca.binding.rmi.RMIBinding;
import scallop.sca.binding.rmi.provider.RMIBindingInvoker;
import scallop.sca.binding.rmi.provider.RMIBindingMasterSlaveLoadBalanceInvoker;
import scallop.sca.binding.rmi.provider.RMIBindingNotifyInvoker;
import scallop.sca.host.rmi.RMIHost;

public class RMIReferenceBindingProvider
implements ReferenceBindingProvider {
    private static final String NOTIFY = "notify";
    private static final Log log = LogFactory.getLog(RMIReferenceBindingProvider.class);
    private RuntimeComponentReference reference;
    private RMIBinding binding;
    private RMIHost rmiHost;

    public RMIReferenceBindingProvider(EndpointReference endpointReference, RMIHost rmiHost) {
        this.reference = (RuntimeComponentReference)endpointReference.getReference();
        this.binding = (RMIBinding)endpointReference.getBinding();
        this.rmiHost = rmiHost;
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.reference.getInterfaceContract();
    }

    public Invoker createInvoker(Operation operation) {
        Method remoteMethod;
        Class iface = ((JavaInterface)this.reference.getInterfaceContract().getInterface()).getJavaClass();
        try {
            remoteMethod = JavaInterfaceUtil.findMethod((Class)iface, (Operation)operation);
            if (this.binding.getMode() != null && !this.binding.getMode().isEmpty() && this.binding.getMode().trim().equals(NOTIFY)) {
                try {
                    return new RMIBindingNotifyInvoker(this.rmiHost, this.binding.getRegistryCenter(), this.binding.getRegistryName(), this.binding.getServiceName(), remoteMethod);
                }
                catch (Exception e) {
                    throw new ServiceRuntimeException(operation.toString(), (Throwable)e);
                }
            }
            if (this.binding.getRegistryName() != null && !this.binding.getRegistryName().isEmpty()) {
                try {
                    return new RMIBindingMasterSlaveLoadBalanceInvoker(this.rmiHost, this.binding.getRegistryCenter(), this.binding.getRegistryName(), this.binding.getServiceName(), remoteMethod);
                }
                catch (Exception e) {
                    throw new ServiceRuntimeException(operation.toString(), (Throwable)e);
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        return new RMIBindingInvoker(this.rmiHost, this.binding.getURI(), remoteMethod);
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }
}

