/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.rmi.provider;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scallop.core.Observer;
import scallop.core.Resource;
import scallop.core.ResourceParser;
import scallop.core.ScallopClient;
import scallop.core.exception.ScallopRemoteException;
import scallop.core.loadbalance.DefaultLoadBalancer;
import scallop.core.util.StringSupport;
import scallop.sca.binding.rmi.provider.RMIRemote;
import scallop.sca.binding.rmi.provider.RMIResourceParser;

public class RMINotifyObserver
implements Observer {
    private static final Logger logger = LoggerFactory.getLogger(RMINotifyObserver.class);
    private DefaultLoadBalancer<RMIRemote> loadBalancer;
    private String registryCenter;
    private String registryName;
    private static final String COLON = ":";

    public RMINotifyObserver(String registryCenter, String registryName) {
        this.registryCenter = registryCenter;
        this.registryName = registryName;
    }

    public void update(boolean isFromSchedule) throws ScallopRemoteException {
        Resource resource = ScallopClient.getInstance().getResource(this.registryCenter, this.registryName, isFromSchedule, (ResourceParser)new RMIResourceParser());
        if (logger.isDebugEnabled() && resource != null) {
            logger.debug("RMIObserver = " + resource.toString());
        }
        if (resource == null || resource.getResource() == null || resource.getResource().size() == 0) {
            logger.info("can not get resource. resource name:" + this.registryName);
            throw new ScallopRemoteException("can not get resource. resource name:" + this.registryName);
        }
        HashSet<RMIRemote> mslbs = new HashSet<RMIRemote>();
        for (String res : resource.getResource()) {
            Set<RMIRemote> mslb = RMINotifyObserver.createResource(res);
            if (mslb == null) continue;
            mslbs.addAll(mslb);
        }
        if (mslbs.size() == 0) {
            throw new ScallopRemoteException("can not parse resource. resource name:" + this.registryName);
        }
        if (this.loadBalancer == null) {
            this.loadBalancer = new DefaultLoadBalancer(mslbs);
        } else {
            HashSet<RMIRemote> newMslbs = new HashSet<RMIRemote>();
            Set oldMslbs = this.loadBalancer.getResources();
            for (RMIRemote rr : mslbs) {
                if (oldMslbs.contains(rr)) continue;
                newMslbs.add(rr);
            }
            HashSet<RMIRemote> uselessFolbs = new HashSet<RMIRemote>();
            for (RMIRemote rr : oldMslbs) {
                if (mslbs.contains(rr)) continue;
                uselessFolbs.add(rr);
            }
            if (!newMslbs.isEmpty()) {
                oldMslbs.addAll(newMslbs);
            }
            if (!uselessFolbs.isEmpty()) {
                oldMslbs.removeAll(uselessFolbs);
            }
        }
    }

    private static Set<RMIRemote> createResource(String res) throws ScallopRemoteException {
        StringSupport.CompositeData cd = StringSupport.parseComposite((String)res);
        String[] st = cd.getComponents();
        HashSet<RMIRemote> set = new HashSet<RMIRemote>();
        for (String rs : st) {
            String[] hostPort = rs.split(COLON);
            set.add(new RMIRemote(hostPort[0], hostPort[1]));
        }
        return set;
    }

    public DefaultLoadBalancer<RMIRemote> getLoadBalancer() {
        return this.loadBalancer;
    }
}

