/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.rmi.provider;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scallop.core.Observer;
import scallop.core.Resource;
import scallop.core.ResourceParser;
import scallop.core.ScallopClient;
import scallop.core.exception.ScallopRemoteException;
import scallop.core.loadbalance.LoadBalancer;
import scallop.core.loadbalance.MasterSlaveLoadBalancer;
import scallop.core.loadbalance.RoundRobinLoadBalancer;
import scallop.core.util.StringSupport;
import scallop.sca.binding.rmi.provider.RMIRemote;
import scallop.sca.binding.rmi.provider.RMIResourceParser;

public class RMIMasterSlaveObserver
implements Observer {
    private static final Logger logger = LoggerFactory.getLogger(RMIMasterSlaveObserver.class);
    private RoundRobinLoadBalancer<MasterSlaveLoadBalancer<RMIRemote>> loadBalancer;
    private String registryCenter;
    private String registryName;
    private static final String COLON = ":";

    public RMIMasterSlaveObserver(String registryCenter, String registryName) {
        this.registryCenter = registryCenter;
        this.registryName = registryName;
    }

    public void update(boolean isFromSchedule) throws ScallopRemoteException {
        Resource resource = ScallopClient.getInstance().getResource(this.registryCenter, this.registryName, isFromSchedule, (ResourceParser)new RMIResourceParser());
        if (logger.isDebugEnabled() && resource != null) {
            logger.debug("RMIObserver = " + resource.toString());
        }
        if (resource == null || resource.getResource() == null || resource.getResource().size() == 0) {
            logger.info("can not get resource. resource name:" + this.registryName);
            throw new ScallopRemoteException("can not get resource. resource name:" + this.registryName);
        }
        ArrayList<MasterSlaveLoadBalancer<RMIRemote>> mslbs = new ArrayList<MasterSlaveLoadBalancer<RMIRemote>>();
        for (String res : resource.getResource()) {
            MasterSlaveLoadBalancer<RMIRemote> mslb = RMIMasterSlaveObserver.createMasterSlaveLoadBalancer(res);
            if (mslb == null) continue;
            mslbs.add(mslb);
        }
        if (mslbs.size() == 0) {
            throw new ScallopRemoteException("can not parse resource. resource name:" + this.registryName);
        }
        if (this.loadBalancer == null) {
            this.loadBalancer = new RoundRobinLoadBalancer(mslbs);
        } else {
            ArrayList<MasterSlaveLoadBalancer> newMslbs = new ArrayList<MasterSlaveLoadBalancer>();
            List oldMslbs = this.loadBalancer.getResources();
            for (MasterSlaveLoadBalancer masterSlaveLoadBalancer : mslbs) {
                if (oldMslbs.indexOf(masterSlaveLoadBalancer) != -1) continue;
                newMslbs.add(masterSlaveLoadBalancer);
            }
            ArrayList<MasterSlaveLoadBalancer> uselessFolbs = new ArrayList<MasterSlaveLoadBalancer>();
            for (MasterSlaveLoadBalancer rr : oldMslbs) {
                if (mslbs.indexOf(rr) != -1) continue;
                uselessFolbs.add(rr);
            }
            if (!newMslbs.isEmpty()) {
                oldMslbs.addAll(newMslbs);
            }
            if (!uselessFolbs.isEmpty()) {
                oldMslbs.removeAll(uselessFolbs);
            }
        }
    }

    private static MasterSlaveLoadBalancer<RMIRemote> createMasterSlaveLoadBalancer(String res) throws ScallopRemoteException {
        StringSupport.CompositeData cd = StringSupport.parseComposite((String)res);
        String[] st = cd.getComponents();
        ArrayList<RMIRemote> l = new ArrayList<RMIRemote>();
        for (String rs : st) {
            String[] hostPort = rs.split(COLON);
            l.add(new RMIRemote(hostPort[0], hostPort[1]));
        }
        MasterSlaveLoadBalancer mslb = new MasterSlaveLoadBalancer(l);
        return mslb;
    }

    public static MasterSlaveLoadBalancer<RMIRemote> getMasterSlaveLoadBalancer(String str) {
        return null;
    }

    public LoadBalancer<MasterSlaveLoadBalancer<RMIRemote>> getLoadBalancer() {
        return this.loadBalancer;
    }
}

