/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.rmi.provider;

import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import scallop.sca.binding.rmi.RMIBinding;
import scallop.sca.binding.rmi.provider.RMIReferenceBindingProvider;
import scallop.sca.binding.rmi.provider.RMIServiceBindingProvider;
import scallop.sca.host.rmi.DefaultRMIHostExtensionPoint;
import scallop.sca.host.rmi.ExtensibleRMIHost;
import scallop.sca.host.rmi.RMIHost;
import scallop.sca.host.rmi.RMIHostExtensionPoint;

public class RMIBindingProviderFactory
implements BindingProviderFactory<RMIBinding> {
    private RMIHost rmiHost;

    public RMIBindingProviderFactory(ExtensionPointRegistry extensionPoints) {
        RMIHostExtensionPoint rmiHosts = (RMIHostExtensionPoint)extensionPoints.getExtensionPoint(RMIHostExtensionPoint.class);
        if (rmiHosts == null) {
            rmiHosts = new DefaultRMIHostExtensionPoint();
        }
        this.rmiHost = new ExtensibleRMIHost(rmiHosts);
    }

    public ReferenceBindingProvider createReferenceBindingProvider(RuntimeEndpointReference endpointReference) {
        return new RMIReferenceBindingProvider((EndpointReference)endpointReference, this.rmiHost);
    }

    public ServiceBindingProvider createServiceBindingProvider(RuntimeEndpoint endpoint) {
        return new RMIServiceBindingProvider(endpoint, this.rmiHost);
    }

    public Class<RMIBinding> getModelType() {
        return RMIBinding.class;
    }
}

