/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.rmi.provider;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.oasisopen.sca.ServiceRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.remoting.rmi.RmiInvocationHandler;
import org.springframework.remoting.support.RemoteInvocation;
import scallop.core.Observer;
import scallop.core.ScallopClient;
import scallop.core.exception.ScallopRemoteException;
import scallop.core.loadbalance.DefaultLoadBalancer;
import scallop.core.util.StringSupport;
import scallop.sca.binding.rmi.exception.NotifyException;
import scallop.sca.binding.rmi.provider.IInvoker;
import scallop.sca.binding.rmi.provider.RMINotifyObserver;
import scallop.sca.binding.rmi.provider.RMIRemote;
import scallop.sca.host.rmi.RMIHost;

public class RMIBindingNotifyInvoker
implements Invoker,
DataExchangeSemantics,
IInvoker {
    private static final Logger logger = LoggerFactory.getLogger(RMIBindingNotifyInvoker.class);
    private RMIHost rmiHost;
    private String registryCenter;
    private String registryName;
    private String svcName;
    private Method remoteMethod;
    private RMINotifyObserver observer;
    private static final String POINT = ".";
    private static final int retry = 2;
    private static Map<String, Long> methodExecuteMap = new ConcurrentHashMap<String, Long>();

    public RMIBindingNotifyInvoker(RMIHost rmiHost, String registryCenter, String registryName, String svcName, Method remoteMethod) throws ConnectException, NumberFormatException, ScallopRemoteException {
        this.rmiHost = rmiHost;
        this.remoteMethod = remoteMethod;
        this.svcName = svcName;
        ScallopClient sc = ScallopClient.getInstance();
        this.registryName = registryName;
        this.registryCenter = sc.getRealRegistryCenter(registryCenter);
        this.observer = new RMINotifyObserver(this.registryCenter, this.registryName);
        sc.registerObserver((Observer)this.observer);
        this.observer.update(false);
    }

    public Message invoke(Message msg) {
        try {
            Object[] args = (Object[])msg.getBody();
            Object resp = this.invokeTarget(args);
            msg.setBody(resp);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ServiceRuntimeException) {
                msg.setFaultBody((Object)e.getCause().getCause());
            } else {
                msg.setFaultBody((Object)e.getCause());
            }
        }
        catch (Exception e) {
            msg.setFaultBody((Object)e);
        }
        return msg;
    }

    private void statMethodExecute(String svcName, String method) {
        String key = new StringBuffer(svcName).append(POINT).append(method).toString();
        Long counter = methodExecuteMap.get(key);
        if (counter == null) {
            counter = 1L;
        } else {
            Long l = counter;
            Long l2 = counter = Long.valueOf(counter + 1L);
        }
        methodExecuteMap.put(key, counter);
    }

    public Object invokeTarget(Object payload) throws NotifyException, InvocationTargetException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException {
        long startTime = 0L;
        if (logger.isInfoEnabled()) {
            startTime = System.currentTimeMillis();
            this.statMethodExecute(this.svcName, this.remoteMethod.getName());
        }
        Object obj = null;
        boolean result = true;
        StringBuffer sb = new StringBuffer("Notify invokeTarget Exception: ");
        DefaultLoadBalancer<RMIRemote> rr = this.observer.getLoadBalancer();
        for (RMIRemote rrm : rr.getResources()) {
            boolean tmpFlag = false;
            int nu = 2;
            while (nu-- > 0 && !tmpFlag) {
                Object proxy = null;
                try {
                    if (proxy == null) {
                        proxy = this.rmiHost.findService(StringSupport.getURI((String)rrm.getHost(), (String)rrm.getPort(), (String)this.svcName));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("call notify Mode  proxy = " + rrm.getHost() + "; " + rrm.getPort());
                    }
                    if (proxy instanceof RmiInvocationHandler) {
                        RemoteInvocation invocation = new RemoteInvocation(this.remoteMethod.getName(), (Class[])this.remoteMethod.getParameterTypes(), (Object[])payload);
                        Method method = proxy.getClass().getMethod("invoke", RemoteInvocation.class);
                        obj = method.invoke(proxy, invocation);
                    } else {
                        this.remoteMethod = proxy.getClass().getMethod(this.remoteMethod.getName(), this.remoteMethod.getParameterTypes());
                        obj = payload != null && !payload.getClass().isArray() ? this.remoteMethod.invoke(proxy, payload) : this.remoteMethod.invoke(proxy, (Object[])payload);
                    }
                    tmpFlag = true;
                }
                catch (Exception exp) {
                    sb.append(this.svcName).append(POINT).append(this.remoteMethod.getName()).append(" ").append(rrm.getHost()).append(" : ").append(rrm.getPort()).append(" time: ").append(System.currentTimeMillis() - startTime).append("; ");
                    logger.error(new StringBuffer("RMIBindingMasterSlave invokeTarget Exception: ").append(this.svcName).append(POINT).append(this.remoteMethod.getName()).append(" ").append(rrm.getHost()).append(" : ").append(rrm.getPort()).append(" time: ").append(System.currentTimeMillis() - startTime).toString(), (Throwable)exp);
                }
            }
            result &= tmpFlag;
        }
        if (!result) {
            throw new NotifyException(sb.toString());
        }
        return obj;
    }

    public boolean allowsPassByReference() {
        return true;
    }
}

