/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.rmi.provider;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.oasisopen.sca.ServiceRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.remoting.rmi.RmiInvocationHandler;
import org.springframework.remoting.support.RemoteInvocation;
import scallop.core.Observer;
import scallop.core.ScallopClient;
import scallop.core.exception.ScallopRemoteException;
import scallop.core.loadbalance.MasterSlaveLoadBalancer;
import scallop.core.loadbalance.ResourceLoader;
import scallop.core.util.StringSupport;
import scallop.sca.binding.rmi.provider.IInvoker;
import scallop.sca.binding.rmi.provider.RMIMasterSlaveObserver;
import scallop.sca.binding.rmi.provider.RMIRemote;
import scallop.sca.host.rmi.RMIHost;

public class RMIBindingMasterSlaveLoadBalanceInvoker
implements Invoker,
DataExchangeSemantics,
IInvoker {
    private static final Logger logger = LoggerFactory.getLogger(RMIBindingMasterSlaveLoadBalanceInvoker.class);
    private RMIHost rmiHost;
    private String registryCenter;
    private String registryName;
    private String svcName;
    private Method remoteMethod;
    private RMIMasterSlaveObserver observer;
    private static final String POINT = ".";
    private static final int retry = 2;
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static Map<String, Long> methodExecuteMap;

    public RMIBindingMasterSlaveLoadBalanceInvoker(RMIHost rmiHost, String registryCenter, String registryName, String svcName, Method remoteMethod) throws ConnectException, NumberFormatException, ScallopRemoteException {
        this.rmiHost = rmiHost;
        this.remoteMethod = remoteMethod;
        this.svcName = svcName;
        ScallopClient sc = ScallopClient.getInstance();
        this.registryName = registryName;
        this.registryCenter = sc.getRealRegistryCenter(registryCenter);
        this.observer = new RMIMasterSlaveObserver(this.registryCenter, this.registryName);
        sc.registerObserver((Observer)this.observer);
        this.observer.update(false);
    }

    public Message invoke(Message msg) {
        try {
            Object[] args = (Object[])msg.getBody();
            Object resp = this.invokeTarget(args);
            msg.setBody(resp);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ServiceRuntimeException) {
                msg.setFaultBody((Object)e.getCause().getCause());
            } else {
                msg.setFaultBody((Object)e.getCause());
            }
        }
        catch (Exception e) {
            msg.setFaultBody((Object)e);
        }
        return msg;
    }

    private void statMethodExecute(String svcName, String method) {
        String key = new StringBuffer(svcName).append(POINT).append(method).toString();
        Long counter = methodExecuteMap.get(key);
        if (counter == null) {
            counter = 1L;
        } else {
            Long l = counter;
            Long l2 = counter = Long.valueOf(counter + 1L);
        }
        methodExecuteMap.put(key, counter);
    }

    public Object invokeTarget(Object payload) throws InvocationTargetException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException {
        long startTime = 0L;
        if (logger.isInfoEnabled()) {
            startTime = System.currentTimeMillis();
            this.statMethodExecute(this.svcName, this.remoteMethod.getName());
        }
        ResourceLoader rr = this.observer.getLoadBalancer().get();
        MasterSlaveLoadBalancer mslb = (MasterSlaveLoadBalancer)rr.getResource();
        for (RMIRemote rrm : mslb.getResources()) {
            for (int re = 0; re < 2; ++re) {
                Object proxy = null;
                try {
                    long time;
                    if (proxy == null) {
                        proxy = this.rmiHost.findService(StringSupport.getURI((String)rrm.getHost(), (String)rrm.getPort(), (String)this.svcName));
                    }
                    Object obj = null;
                    if (proxy instanceof RmiInvocationHandler) {
                        RemoteInvocation invocation = new RemoteInvocation(this.remoteMethod.getName(), (Class[])this.remoteMethod.getParameterTypes(), (Object[])payload);
                        Method method = proxy.getClass().getMethod("invoke", RemoteInvocation.class);
                        obj = method.invoke(proxy, invocation);
                        if (logger.isDebugEnabled()) {
                            logger.debug("proxy is RmiInvocationHandler " + rrm.getHost() + "; " + rrm.getPort() + "; " + this.svcName + "; " + this.remoteMethod.getName() + "; obj=" + obj);
                        }
                    } else {
                        this.remoteMethod = proxy.getClass().getMethod(this.remoteMethod.getName(), this.remoteMethod.getParameterTypes());
                        obj = payload != null && !payload.getClass().isArray() ? this.remoteMethod.invoke(proxy, payload) : this.remoteMethod.invoke(proxy, (Object[])payload);
                        if (logger.isDebugEnabled()) {
                            logger.debug("proxy is not RmiInvocationHandler " + rrm.getHost() + "; " + rrm.getPort() + "; " + this.svcName + "; " + this.remoteMethod.getName() + "; obj=" + obj);
                        }
                    }
                    if (logger.isInfoEnabled() && (time = System.currentTimeMillis() - startTime) > ScallopClient.getInstance().getRmiProcessTimeThreshold()) {
                        Object[] objs = (Object[])payload;
                        if (ScallopClient.getInstance().getRmiShowParameters()) {
                            StringBuffer sb = new StringBuffer();
                            int length = objs.length;
                            for (int i = 0; i < length; ++i) {
                                sb.append(i).append(":").append(objs[i]).append(")");
                            }
                            logger.info(new StringBuffer("method process stat: ").append(this.svcName).append(POINT).append(this.remoteMethod.getName()).append(" time: ").append(time).append(" params:").append(sb.toString()).toString());
                        } else {
                            logger.info(new StringBuffer("method process stat: ").append(this.svcName).append(POINT).append(this.remoteMethod.getName()).append(" time: ").append(time).toString());
                        }
                    }
                    return obj;
                }
                catch (Exception exp) {
                    logger.error(new StringBuffer("RMIBindingMasterSlave invokeTarget Exception: ").append(this.svcName).append(POINT).append(this.remoteMethod.getName()).append(" time: ").append(System.currentTimeMillis() - startTime).toString(), (Throwable)exp);
                    continue;
                }
            }
        }
        throw new InvocationTargetException(new Exception("invokeTarget RMI master slaver error serviceName = " + this.svcName + "; memtod = " + this.remoteMethod.getName()));
    }

    public boolean allowsPassByReference() {
        return true;
    }

    static {
        if (logger.isInfoEnabled()) {
            scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    for (Map.Entry entry : methodExecuteMap.entrySet()) {
                        logger.info("method invoke stat: " + (String)entry.getKey() + " count: " + entry.getValue() + " interval: " + ScallopClient.getInstance().getRmiExecuteTimesPrintInterval() + " rate: " + (Long)entry.getValue() / (ScallopClient.getInstance().getRmiExecuteTimesPrintInterval() / 60L) + " t/m");
                    }
                    methodExecuteMap = new ConcurrentHashMap();
                }
            }, ScallopClient.getInstance().getRmiExecuteTimesPrintInterval(), ScallopClient.getInstance().getRmiExecuteTimesPrintInterval(), TimeUnit.SECONDS);
        }
        methodExecuteMap = new ConcurrentHashMap<String, Long>();
    }
}

