/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.rmi.provider;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import scallop.sca.host.rmi.RMIHost;

public class RMIBindingInvoker
implements Invoker {
    private RMIHost rmiHost;
    private String uri;
    private Method remoteMethod;

    public RMIBindingInvoker(RMIHost rmiHost, String uri, Method remoteMethod) {
        this.rmiHost = rmiHost;
        this.remoteMethod = remoteMethod;
        this.uri = uri;
    }

    public Message invoke(Message msg) {
        try {
            Object[] args = (Object[])msg.getBody();
            Object resp = this.invokeTarget(args);
            msg.setBody(resp);
        }
        catch (InvocationTargetException e) {
            msg.setFaultBody((Object)e.getCause());
        }
        catch (Exception e) {
            msg.setFaultBody((Object)e);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeTarget(Object payload) throws InvocationTargetException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException {
        Remote proxy = null;
        Class<?> remote = this.remoteMethod.getDeclaringClass();
        final ClassLoader stubClassLoader = remote.getClassLoader();
        ClassLoader tccl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(stubClassLoader);
                return tccl;
            }
        });
        try {
            proxy = this.rmiHost.findService(this.uri);
        }
        catch (Throwable throwable) {
            AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(tccl){
                final /* synthetic */ ClassLoader val$tccl;
                {
                    this.val$tccl = classLoader;
                }

                @Override
                public ClassLoader run() {
                    ClassLoader current = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.val$tccl);
                    return current;
                }
            });
            throw throwable;
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        this.remoteMethod = proxy.getClass().getMethod(this.remoteMethod.getName(), this.remoteMethod.getParameterTypes());
        if (payload != null && !payload.getClass().isArray()) {
            return this.remoteMethod.invoke((Object)proxy, payload);
        }
        return this.remoteMethod.invoke((Object)proxy, (Object[])payload);
    }
}

