/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.id;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

public class TimeIdHelper {
    private static final int TIME_BIT_MOVE = 22;
    private static final int IDC_BIT_MOVE = 18;
    private static final int IDC_MAX = 15;
    public static final long TIME_BIT = -4194304L;
    public static final long IDC_ID_BIT = Long.valueOf(15L) << 18;
    public static final long SEQ_BIT = 262143L;
    private static final int DEFAULT_IDC = 6;
    private static int DEFAULT_ID_INTEVAL = 5;

    public static boolean isUuidAfterUpdate(long id) {
        return TimeIdHelper.isValidId(id) && id > 3342818919841793L;
    }

    public static boolean isValidId(long id) {
        return id > 3000000000000000L && id < 4500000000000000L;
    }

    public static long getTimeFromId(long id) {
        return TimeIdHelper.getTimeNumberFromId(id) + 515483463L;
    }

    public static long getTimeNumberFromId(long id) {
        return id >> 22;
    }

    public static long getIdcIdFromId(long id) {
        return (id & IDC_ID_BIT) >> 18;
    }

    public static long getSeqFromId(long id) {
        return id & 0x3FFFFL;
    }

    public static Date getDateFromId(long id) {
        return new Date(TimeIdHelper.getTimeFromId(id) * 1000L);
    }

    public static long getIdByDate(Date date, AtomicLong sid) {
        long uuid = date.getTime() / 1000L;
        uuid -= 515483463L;
        uuid <<= 22;
        uuid += 0x180000L;
        long sidValue = sid.addAndGet(DEFAULT_ID_INTEVAL);
        return uuid += sidValue % 262144L;
    }

    public static long getIdByDate(Date date, AtomicLong sid, int idc) {
        if (idc < 0 || idc > 15) {
            throw new RuntimeException("idc value must in 0 ~ 15");
        }
        long uuid = date.getTime() / 1000L;
        uuid -= 515483463L;
        uuid <<= 22;
        uuid += (long)(idc << 18);
        long sidValue = sid.addAndGet(DEFAULT_ID_INTEVAL);
        return uuid += sidValue % 262144L;
    }

    public static long getIdByDate(Long currentTimeMillis, AtomicLong sid, int idc) {
        if (idc < 0 || idc > 15) {
            throw new RuntimeException("idc value must in 0 ~ 15");
        }
        long uuid = currentTimeMillis / 1000L;
        uuid -= 515483463L;
        uuid <<= 22;
        uuid += (long)(idc << 18);
        long sidValue = sid.addAndGet(DEFAULT_ID_INTEVAL);
        return uuid += sidValue % 262144L;
    }

    public static void main(String[] args) {
        AtomicLong sid = new AtomicLong(0L);
        ArrayList<Long> ids = new ArrayList<Long>();
        int i = 0;
        while (i < 100) {
            long id = TimeIdHelper.getIdByDate(new Date(), sid, 0);
            ids.add(id);
            ++i;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd 'T' HH:mm:ss");
        for (Long id : ids) {
            Date date = TimeIdHelper.getDateFromId(id);
            long idSeq = TimeIdHelper.getSeqFromId(id);
            long idc = TimeIdHelper.getIdcIdFromId(id);
            System.out.println("id " + id + " " + dateFormat.format(date) + " idc: " + idc + " idSeq: " + idSeq);
        }
    }
}

