/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.AbstractInput;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.Format;
import java.math.BigInteger;

class WidenerInput
extends AbstractInput {
    private EntityInput input;
    private int fromFormatId;
    private int toFormatId;

    static boolean isWideningSupported(Format fromFormat, Format toFormat, boolean isSecKeyField) {
        int fromFormatId = fromFormat.getId();
        int toFormatId = toFormat.getId();
        switch (fromFormatId) {
            case 2: {
                switch (toFormatId) {
                    case 3: {
                        return true;
                    }
                }
                return false;
            }
            case 4: {
                switch (toFormatId) {
                    case 5: {
                        return true;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 19: {
                        return !isSecKeyField;
                    }
                }
                return false;
            }
            case 5: {
                switch (toFormatId) {
                    case 7: 
                    case 9: 
                    case 11: 
                    case 13: 
                    case 15: 
                    case 19: {
                        return !isSecKeyField;
                    }
                }
                return false;
            }
            case 6: {
                switch (toFormatId) {
                    case 7: {
                        return true;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 19: {
                        return !isSecKeyField;
                    }
                }
                return false;
            }
            case 7: {
                switch (toFormatId) {
                    case 9: 
                    case 11: 
                    case 13: 
                    case 15: 
                    case 19: {
                        return !isSecKeyField;
                    }
                }
                return false;
            }
            case 8: {
                switch (toFormatId) {
                    case 9: {
                        return true;
                    }
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 19: {
                        return !isSecKeyField;
                    }
                }
                return false;
            }
            case 9: {
                switch (toFormatId) {
                    case 11: 
                    case 13: 
                    case 15: 
                    case 19: {
                        return !isSecKeyField;
                    }
                }
                return false;
            }
            case 10: {
                switch (toFormatId) {
                    case 11: {
                        return true;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 19: {
                        return !isSecKeyField;
                    }
                }
                return false;
            }
            case 11: {
                switch (toFormatId) {
                    case 13: 
                    case 15: 
                    case 19: {
                        return !isSecKeyField;
                    }
                }
                return false;
            }
            case 12: {
                switch (toFormatId) {
                    case 13: {
                        return true;
                    }
                    case 14: 
                    case 15: {
                        return !isSecKeyField;
                    }
                }
                return false;
            }
            case 13: {
                switch (toFormatId) {
                    case 15: {
                        return !isSecKeyField;
                    }
                }
                return false;
            }
            case 14: {
                switch (toFormatId) {
                    case 15: {
                        return true;
                    }
                }
                return false;
            }
            case 16: {
                switch (toFormatId) {
                    case 17: {
                        return true;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 19: {
                        return !isSecKeyField;
                    }
                }
                return false;
            }
            case 17: {
                switch (toFormatId) {
                    case 9: 
                    case 11: 
                    case 13: 
                    case 15: 
                    case 19: {
                        return !isSecKeyField;
                    }
                }
                return false;
            }
        }
        return false;
    }

    WidenerInput(EntityInput input, int fromFormatId, int toFormatId) {
        super(input.getCatalog(), input.isRawAccess());
        this.input = input;
        this.fromFormatId = fromFormatId;
        this.toFormatId = toFormatId;
    }

    @Override
    public void registerPriKeyObject(Object o) {
        this.input.registerPriKeyObject(o);
    }

    @Override
    public int readArrayLength() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readEnumConstant(String[] names) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void skipField(Format declaredFormat) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object readKeyObject(Format fromFormat) {
        return this.readObject();
    }

    @Override
    public Object readObject() {
        switch (this.fromFormatId) {
            case 2: {
                this.checkToFormat(3);
                return this.input.readBoolean();
            }
            case 4: {
                return this.byteToObject(this.input.readByte());
            }
            case 5: {
                Byte b = (Byte)this.input.readObject();
                return b != null ? this.byteToObject(b) : null;
            }
            case 6: {
                return this.shortToObject(this.input.readShort());
            }
            case 7: {
                Short s = (Short)this.input.readObject();
                return s != null ? this.shortToObject(s) : null;
            }
            case 8: {
                return this.intToObject(this.input.readInt());
            }
            case 9: {
                Integer i = (Integer)this.input.readObject();
                return i != null ? this.intToObject(i) : null;
            }
            case 10: {
                return this.longToObject(this.input.readLong());
            }
            case 11: {
                Long l = (Long)this.input.readObject();
                return l != null ? this.longToObject(l) : null;
            }
            case 12: {
                return this.floatToObject(this.input.readSortedFloat());
            }
            case 13: {
                Float f = (Float)this.input.readObject();
                return f != null ? this.floatToObject(f.floatValue()) : null;
            }
            case 14: {
                this.checkToFormat(15);
                return this.input.readSortedDouble();
            }
            case 16: {
                return this.charToObject(this.input.readChar());
            }
            case 17: {
                Character c = (Character)this.input.readObject();
                return c != null ? this.charToObject(c.charValue()) : null;
            }
        }
        throw new IllegalStateException(String.valueOf(this.fromFormatId));
    }

    private Object byteToObject(byte v) {
        switch (this.toFormatId) {
            case 4: 
            case 5: {
                return v;
            }
            case 6: 
            case 7: {
                return (short)v;
            }
            case 8: 
            case 9: {
                return (int)v;
            }
            case 10: 
            case 11: {
                return (long)v;
            }
            case 12: 
            case 13: {
                return Float.valueOf(v);
            }
            case 14: 
            case 15: {
                return (double)v;
            }
            case 19: {
                return BigInteger.valueOf(v);
            }
        }
        throw new IllegalStateException(String.valueOf(this.toFormatId));
    }

    private Object shortToObject(short v) {
        switch (this.toFormatId) {
            case 6: 
            case 7: {
                return v;
            }
            case 8: 
            case 9: {
                return (int)v;
            }
            case 10: 
            case 11: {
                return (long)v;
            }
            case 12: 
            case 13: {
                return Float.valueOf(v);
            }
            case 14: 
            case 15: {
                return (double)v;
            }
            case 19: {
                return BigInteger.valueOf(v);
            }
        }
        throw new IllegalStateException(String.valueOf(this.toFormatId));
    }

    private Object intToObject(int v) {
        switch (this.toFormatId) {
            case 8: 
            case 9: {
                return v;
            }
            case 10: 
            case 11: {
                return (long)v;
            }
            case 12: 
            case 13: {
                return Float.valueOf(v);
            }
            case 14: 
            case 15: {
                return (double)v;
            }
            case 19: {
                return BigInteger.valueOf(v);
            }
        }
        throw new IllegalStateException(String.valueOf(this.toFormatId));
    }

    private Object longToObject(long v) {
        switch (this.toFormatId) {
            case 10: 
            case 11: {
                return v;
            }
            case 12: 
            case 13: {
                return Float.valueOf(v);
            }
            case 14: 
            case 15: {
                return (double)v;
            }
            case 19: {
                return BigInteger.valueOf(v);
            }
        }
        throw new IllegalStateException(String.valueOf(this.toFormatId));
    }

    private Object floatToObject(float v) {
        switch (this.toFormatId) {
            case 12: 
            case 13: {
                return Float.valueOf(v);
            }
            case 14: 
            case 15: {
                return (double)v;
            }
        }
        throw new IllegalStateException(String.valueOf(this.toFormatId));
    }

    private Object charToObject(char v) {
        switch (this.toFormatId) {
            case 16: 
            case 17: {
                return Character.valueOf(v);
            }
            case 8: 
            case 9: {
                return (int)v;
            }
            case 10: 
            case 11: {
                return (long)v;
            }
            case 12: 
            case 13: {
                return Float.valueOf(v);
            }
            case 14: 
            case 15: {
                return (double)v;
            }
            case 19: {
                return BigInteger.valueOf(v);
            }
        }
        throw new IllegalStateException(String.valueOf(this.toFormatId));
    }

    @Override
    public char readChar() {
        throw new IllegalStateException(String.valueOf(this.fromFormatId));
    }

    @Override
    public boolean readBoolean() {
        throw new IllegalStateException(String.valueOf(this.fromFormatId));
    }

    @Override
    public byte readByte() {
        throw new IllegalStateException(String.valueOf(this.fromFormatId));
    }

    @Override
    public short readShort() {
        this.checkToFormat(6);
        switch (this.fromFormatId) {
            case 4: {
                return this.input.readByte();
            }
        }
        throw new IllegalStateException(String.valueOf(this.fromFormatId));
    }

    @Override
    public int readInt() {
        this.checkToFormat(8);
        switch (this.fromFormatId) {
            case 4: {
                return this.input.readByte();
            }
            case 6: {
                return this.input.readShort();
            }
            case 16: {
                return this.input.readChar();
            }
        }
        throw new IllegalStateException(String.valueOf(this.fromFormatId));
    }

    @Override
    public long readLong() {
        this.checkToFormat(10);
        switch (this.fromFormatId) {
            case 4: {
                return this.input.readByte();
            }
            case 6: {
                return this.input.readShort();
            }
            case 8: {
                return this.input.readInt();
            }
            case 16: {
                return this.input.readChar();
            }
        }
        throw new IllegalStateException(String.valueOf(this.fromFormatId));
    }

    @Override
    public float readSortedFloat() {
        this.checkToFormat(12);
        switch (this.fromFormatId) {
            case 4: {
                return this.input.readByte();
            }
            case 6: {
                return this.input.readShort();
            }
            case 8: {
                return this.input.readInt();
            }
            case 10: {
                return this.input.readLong();
            }
            case 16: {
                return this.input.readChar();
            }
        }
        throw new IllegalStateException(String.valueOf(this.fromFormatId));
    }

    @Override
    public double readSortedDouble() {
        this.checkToFormat(14);
        switch (this.fromFormatId) {
            case 4: {
                return this.input.readByte();
            }
            case 6: {
                return this.input.readShort();
            }
            case 8: {
                return this.input.readInt();
            }
            case 10: {
                return this.input.readLong();
            }
            case 12: {
                return this.input.readSortedFloat();
            }
            case 16: {
                return this.input.readChar();
            }
        }
        throw new IllegalStateException(String.valueOf(this.fromFormatId));
    }

    @Override
    public BigInteger readBigInteger() {
        this.checkToFormat(19);
        switch (this.fromFormatId) {
            case 4: {
                return BigInteger.valueOf(this.input.readByte());
            }
            case 6: {
                return BigInteger.valueOf(this.input.readShort());
            }
            case 8: {
                return BigInteger.valueOf(this.input.readInt());
            }
            case 10: {
                return BigInteger.valueOf(this.input.readLong());
            }
            case 16: {
                return BigInteger.valueOf(this.input.readChar());
            }
        }
        throw new IllegalStateException(String.valueOf(this.fromFormatId));
    }

    private void checkToFormat(int id) {
        if (this.toFormatId != id) {
            throw new IllegalStateException(String.valueOf(this.toFormatId));
        }
    }
}

