/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.model.Persistent;
import com.sleepycat.persist.model.PersistentProxy;
import com.sleepycat.persist.raw.RawObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

@Persistent
abstract class CollectionProxy<E>
implements PersistentProxy<Collection<E>> {
    private E[] elements;

    protected CollectionProxy() {
    }

    @Override
    public final void initializeProxy(Collection<E> collection) {
        this.elements = new Object[collection.size()];
        int i = 0;
        for (E element : collection) {
            this.elements[i] = element;
            ++i;
        }
    }

    @Override
    public final Collection<E> convertProxy() {
        Collection<E> collection = this.newInstance(this.elements.length);
        E[] EArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            collection.add(element);
            ++n2;
        }
        return collection;
    }

    protected abstract Collection<E> newInstance(int var1);

    static Object[] getElements(RawObject collection) {
        Object value = null;
        while (value == null && collection != null) {
            Map<String, Object> values = collection.getValues();
            if (values == null || (value = values.get("elements")) != null) continue;
            collection = collection.getSuper();
        }
        if (value == null || !(value instanceof RawObject)) {
            throw new IllegalStateException("Collection proxy for a secondary key field must contain a field named 'elements'");
        }
        RawObject rawObj = (RawObject)value;
        Format format = (Format)rawObj.getType();
        if (!format.isArray() || format.getComponentType().getId() != 1) {
            throw new IllegalStateException("Collection proxy 'elements' field must be an Object array");
        }
        return rawObj.getElements();
    }

    static void setElements(RawObject collection, Object[] elements) {
        RawObject value = null;
        while (value == null && collection != null) {
            Map<String, Object> values = collection.getValues();
            if (values == null) continue;
            value = (RawObject)values.get("elements");
            if (value != null) {
                values.put("elements", new RawObject(value.getType(), elements));
                continue;
            }
            collection = collection.getSuper();
        }
        if (value == null) {
            throw new IllegalStateException();
        }
    }

    static void copyElements(RecordInput input, Format format, Format keyFormat, Set results) {
        RawObject collection = (RawObject)format.newInstance(input, true);
        Object[] elements = CollectionProxy.getElements(collection = (RawObject)format.readObject(collection, input, true));
        if (elements != null) {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object elem = objectArray[n2];
                RecordOutput output = new RecordOutput(input.getCatalog(), true);
                output.writeKeyObject(elem, keyFormat);
                DatabaseEntry entry = new DatabaseEntry();
                TupleBase.outputToEntry(output, entry);
                results.add(entry);
                ++n2;
            }
        }
    }

    @Persistent(proxyFor=ArrayList.class)
    static class ArrayListProxy<E>
    extends CollectionProxy<E> {
        protected ArrayListProxy() {
        }

        @Override
        protected Collection<E> newInstance(int size) {
            return new ArrayList(size);
        }
    }

    @Persistent(proxyFor=HashSet.class)
    static class HashSetProxy<E>
    extends CollectionProxy<E> {
        protected HashSetProxy() {
        }

        @Override
        protected Collection<E> newInstance(int size) {
            return new HashSet(size);
        }
    }

    @Persistent(proxyFor=LinkedList.class)
    static class LinkedListProxy<E>
    extends CollectionProxy<E> {
        protected LinkedListProxy() {
        }

        @Override
        protected Collection<E> newInstance(int size) {
            return new LinkedList();
        }
    }

    @Persistent(proxyFor=TreeSet.class)
    static class TreeSetProxy<E>
    extends CollectionProxy<E> {
        protected TreeSetProxy() {
        }

        @Override
        protected Collection<E> newInstance(int size) {
            return new TreeSet();
        }
    }
}

