/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.evolve;

import com.sleepycat.persist.evolve.Conversion;
import com.sleepycat.persist.evolve.Mutation;
import java.lang.reflect.Method;

public class Converter
extends Mutation {
    private static final long serialVersionUID = 4558176842096181863L;
    private Conversion conversion;

    public Converter(String className, int classVersion, Conversion conversion) {
        this(className, classVersion, null, conversion);
    }

    public Converter(String declaringClassName, int declaringClassVersion, String fieldName, Conversion conversion) {
        super(declaringClassName, declaringClassVersion, fieldName);
        this.conversion = conversion;
        Class<?> cls = conversion.getClass();
        try {
            Method m = cls.getMethod("equals", Object.class);
            if (m.getDeclaringClass() == Object.class) {
                throw new IllegalArgumentException("Conversion class does not implement the equals method explicitly (Object.equals is not sufficient): " + cls.getName());
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    public Conversion getConversion() {
        return this.conversion;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Converter) {
            Converter o = (Converter)other;
            return this.conversion.equals(o.conversion) && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.conversion.hashCode() + super.hashCode();
    }

    @Override
    public String toString() {
        return "[Converter " + super.toString() + " Conversion: " + this.conversion + ']';
    }
}

