/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.DumpFileReader;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.PrintFileReader;
import com.sleepycat.je.log.StatsFileReader;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.utilint.CmdUtil;
import com.sleepycat.je.utilint.DbLsn;
import java.io.File;
import java.io.IOException;

public class DbPrintLog {
    private void dump(File envHome, String entryTypes, String txnIds, long startLsn, long endLsn, boolean verbose, boolean stats) throws IOException, DatabaseException {
        EnvironmentImpl env = CmdUtil.makeUtilityEnvironment(envHome, true);
        FileManager fileManager = env.getFileManager();
        fileManager.setIncludeDeletedFiles(true);
        int readBufferSize = env.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        DumpFileReader reader = null;
        reader = stats ? new StatsFileReader(env, readBufferSize, startLsn, endLsn, entryTypes, txnIds, verbose) : new PrintFileReader(env, readBufferSize, startLsn, endLsn, entryTypes, txnIds, verbose);
        System.out.println("<DbPrintLog>");
        while (reader.readNextEntry()) {
        }
        reader.summarize();
        System.out.println("</DbPrintLog>");
        env.close();
    }

    public static void main(String[] argv) {
        try {
            int whichArg = 0;
            String entryTypes = null;
            String txnIds = null;
            long startLsn = -1L;
            long endLsn = -1L;
            boolean verbose = true;
            boolean stats = false;
            File envHome = new File(".");
            Key.DUMP_TYPE = Key.DumpType.BINARY;
            while (whichArg < argv.length) {
                String arg;
                int slashOff;
                String nextArg = argv[whichArg];
                if (nextArg.equals("-h")) {
                    envHome = new File(CmdUtil.getArg(argv, ++whichArg));
                } else if (nextArg.equals("-ty")) {
                    entryTypes = CmdUtil.getArg(argv, ++whichArg);
                } else if (nextArg.equals("-tx")) {
                    txnIds = CmdUtil.getArg(argv, ++whichArg);
                } else if (nextArg.equals("-s")) {
                    long startFileNum;
                    if ((slashOff = (arg = CmdUtil.getArg(argv, ++whichArg)).indexOf("/")) < 0) {
                        startFileNum = CmdUtil.readLongNumber(arg);
                        startLsn = DbLsn.makeLsn(startFileNum, 0L);
                    } else {
                        startFileNum = CmdUtil.readLongNumber(arg.substring(0, slashOff));
                        long startOffset = CmdUtil.readLongNumber(arg.substring(slashOff + 1));
                        startLsn = DbLsn.makeLsn(startFileNum, startOffset);
                    }
                } else if (nextArg.equals("-e")) {
                    long endFileNum;
                    if ((slashOff = (arg = CmdUtil.getArg(argv, ++whichArg)).indexOf("/")) < 0) {
                        endFileNum = CmdUtil.readLongNumber(arg);
                        endLsn = DbLsn.makeLsn(endFileNum, 0L);
                    } else {
                        endFileNum = CmdUtil.readLongNumber(arg.substring(0, slashOff));
                        long endOffset = CmdUtil.readLongNumber(arg.substring(slashOff + 1));
                        endLsn = DbLsn.makeLsn(endFileNum, endOffset);
                    }
                } else if (nextArg.equals("-k")) {
                    String dumpType;
                    if ((dumpType = CmdUtil.getArg(argv, ++whichArg)).equalsIgnoreCase("text")) {
                        Key.DUMP_TYPE = Key.DumpType.TEXT;
                    } else if (dumpType.equalsIgnoreCase("hex")) {
                        Key.DUMP_TYPE = Key.DumpType.HEX;
                    } else if (dumpType.equalsIgnoreCase("binary")) {
                        Key.DUMP_TYPE = Key.DumpType.BINARY;
                    } else if (dumpType.equalsIgnoreCase("obfuscate")) {
                        Key.DUMP_TYPE = Key.DumpType.OBFUSCATE;
                    } else {
                        System.err.println(String.valueOf(dumpType) + " is not a supported dump format type.");
                    }
                } else if (nextArg.equals("-q")) {
                    ++whichArg;
                    verbose = false;
                } else if (nextArg.equals("-S")) {
                    ++whichArg;
                    stats = true;
                } else {
                    System.err.println(String.valueOf(nextArg) + " is not a supported option.");
                    DbPrintLog.usage();
                    System.exit(-1);
                }
                ++whichArg;
            }
            DbPrintLog printer = new DbPrintLog();
            printer.dump(envHome, entryTypes, txnIds, startLsn, endLsn, verbose, stats);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            DbPrintLog.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("Usage: " + CmdUtil.getJavaCommand(DbPrintLog.class));
        System.out.println(" -h  <envHomeDir>");
        System.out.println(" -e  <end file number or LSN, in hex>");
        System.out.println(" -k  <binary|text|hex|obfuscate> (format for dumping the key)");
        System.out.println(" -s  <start file number or LSN, in hex>");
        System.out.println(" -tx <targetted txn ids, comma separated>");
        System.out.println(" -ty <targetted entry types, comma separated>");
        System.out.println(" -S  show Summary of log entries");
        System.out.println(" -q  if specified, concise version is printed");
        System.out.println("     Default is verbose version.)");
        System.out.println("All arguments are optional");
    }
}

