/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.log.FileHeader;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.DeletedDupLNLogEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.NameLNLogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.CheckpointStart;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINDelta;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INDeleteInfo;
import com.sleepycat.je.tree.INDupDeleteInfo;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.txn.TxnAbort;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.txn.TxnPrepare;
import com.sleepycat.je.utilint.Tracer;
import java.util.HashSet;
import java.util.Set;

public class LogEntryType {
    public static final byte LOG_VERSION = 6;
    private static final int MAX_TYPE_NUM = 27;
    private static LogEntryType[] LOG_TYPES = new LogEntryType[27];
    public static final LogEntryType LOG_LN_TRANSACTIONAL = new LogEntryType(1, "LN_TX", new LNLogEntry((Class<? extends LN>)LN.class), Txnal.TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_NO_MATCH);
    public static final LogEntryType LOG_LN = new LogEntryType(2, "LN", new LNLogEntry((Class<? extends LN>)LN.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_NO_MATCH);
    public static final LogEntryType LOG_MAPLN_TRANSACTIONAL = new LogEntryType(3, "MapLN_TX", new LNLogEntry((Class<? extends LN>)MapLN.class), Txnal.TXNAL, Marshall.INSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType LOG_MAPLN = new LogEntryType(4, "MapLN", new LNLogEntry((Class<? extends LN>)MapLN.class), Txnal.NON_TXNAL, Marshall.INSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType LOG_NAMELN_TRANSACTIONAL = new LogEntryType(5, "NameLN_TX", new NameLNLogEntry(), Txnal.TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_NO_MATCH);
    public static final LogEntryType LOG_NAMELN = new LogEntryType(6, "NameLN", new NameLNLogEntry(), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_NO_MATCH);
    public static final LogEntryType LOG_DEL_DUPLN_TRANSACTIONAL = new LogEntryType(7, "DelDupLN_TX", new DeletedDupLNLogEntry(), Txnal.TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_NO_MATCH);
    public static final LogEntryType LOG_DEL_DUPLN = new LogEntryType(8, "DelDupLN", new DeletedDupLNLogEntry(), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_NO_MATCH);
    public static final LogEntryType LOG_DUPCOUNTLN_TRANSACTIONAL = new LogEntryType(9, "DupCountLN_TX", new LNLogEntry((Class<? extends LN>)DupCountLN.class), Txnal.TXNAL, Marshall.OUTSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType LOG_DUPCOUNTLN = new LogEntryType(10, "DupCountLN", new LNLogEntry((Class<? extends LN>)DupCountLN.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType LOG_FILESUMMARYLN = new LogEntryType(11, "FileSummaryLN", new LNLogEntry((Class<? extends LN>)FileSummaryLN.class), Txnal.NON_TXNAL, Marshall.INSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType LOG_IN = new LogEntryType(12, "IN", new INLogEntry((Class<? extends IN>)IN.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType LOG_BIN = new LogEntryType(13, "BIN", new INLogEntry((Class<? extends IN>)BIN.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType LOG_DIN = new LogEntryType(14, "DIN", new INLogEntry((Class<? extends IN>)DIN.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType LOG_DBIN = new LogEntryType(15, "DBIN", new INLogEntry((Class<? extends IN>)DBIN.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType[] IN_TYPES = new LogEntryType[]{LOG_IN, LOG_BIN, LOG_DIN, LOG_DBIN};
    private static final int MAX_NODE_TYPE_NUM = 15;
    public static final LogEntryType LOG_ROOT = new LogEntryType(16, "Root", new SingleItemEntry(DbTree.class), Txnal.NON_TXNAL, Marshall.INSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType LOG_TXN_COMMIT = new LogEntryType(17, "Commit", new SingleItemEntry(TxnCommit.class), Txnal.TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_MATCH);
    public static final LogEntryType LOG_TXN_ABORT = new LogEntryType(18, "Abort", new SingleItemEntry(TxnAbort.class), Txnal.TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_MATCH);
    public static final LogEntryType LOG_CKPT_START = new LogEntryType(19, "CkptStart", new SingleItemEntry(CheckpointStart.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType LOG_CKPT_END = new LogEntryType(20, "CkptEnd", new SingleItemEntry(CheckpointEnd.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType LOG_IN_DELETE_INFO = new LogEntryType(21, "INDelete", new SingleItemEntry(INDeleteInfo.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType LOG_BIN_DELTA = new LogEntryType(22, "BINDelta", new BINDeltaLogEntry(BINDelta.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType LOG_DUP_BIN_DELTA = new LogEntryType(23, "DupBINDelta", new BINDeltaLogEntry(BINDelta.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType LOG_TRACE = new LogEntryType(24, "Trace", new SingleItemEntry(Tracer.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.REPLICABLE_NO_MATCH);
    public static final LogEntryType LOG_FILE_HEADER = new LogEntryType(25, "FileHeader", new SingleItemEntry(FileHeader.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType LOG_IN_DUPDELETE_INFO = new LogEntryType(26, "INDupDelete", new SingleItemEntry(INDupDeleteInfo.class), Txnal.NON_TXNAL, Marshall.OUTSIDE_LATCH, Replicable.LOCAL);
    public static final LogEntryType LOG_TXN_PREPARE = new LogEntryType(27, "Prepare", new SingleItemEntry(TxnPrepare.class), Txnal.TXNAL, Marshall.OUTSIDE_LATCH, Replicable.LOCAL);
    private final byte typeNum;
    private final String displayName;
    private final LogEntry logEntry;
    private Txnal isTransactional;
    private Marshall marshallBehavior;
    private Replicable replicationPossible;

    public static boolean isNodeType(byte typeNum) {
        return typeNum <= 15;
    }

    LogEntryType(byte typeNum) {
        this.typeNum = typeNum;
        this.displayName = null;
        this.logEntry = null;
    }

    private LogEntryType(byte typeNum, String displayName, LogEntry logEntry, Txnal isTransactional, Marshall marshallBehavior, Replicable replicationPossible) {
        this.typeNum = typeNum;
        this.displayName = displayName;
        this.logEntry = logEntry;
        this.isTransactional = isTransactional;
        this.marshallBehavior = marshallBehavior;
        this.replicationPossible = replicationPossible;
        logEntry.setLogType(this);
        LogEntryType.LOG_TYPES[typeNum - 1] = this;
    }

    public boolean isNodeType() {
        return this.typeNum <= 15;
    }

    public static LogEntryType findType(byte typeNum) {
        if (typeNum <= 0 || typeNum > 27) {
            return null;
        }
        return LOG_TYPES[typeNum - 1];
    }

    public static Set<LogEntryType> getAllTypes() {
        HashSet<LogEntryType> ret = new HashSet<LogEntryType>();
        int i = 0;
        while (i < 27) {
            ret.add(LOG_TYPES[i]);
            ++i;
        }
        return ret;
    }

    public LogEntry getSharedLogEntry() {
        return this.logEntry;
    }

    public LogEntry getNewLogEntry() throws DatabaseException {
        try {
            return (LogEntry)this.logEntry.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DatabaseException(e);
        }
    }

    public byte getTypeNum() {
        return this.typeNum;
    }

    static boolean isValidType(byte typeNum) {
        return typeNum > 0 && typeNum <= 27;
    }

    public String toStringNoVersion() {
        return this.displayName;
    }

    public String toString() {
        return this.displayName;
    }

    public boolean equalsType(byte typeNum) {
        return this.typeNum == typeNum;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LogEntryType)) {
            return false;
        }
        return this.typeNum == ((LogEntryType)obj).typeNum;
    }

    public int hashCode() {
        return this.typeNum;
    }

    public boolean isTransactional() {
        return this.isTransactional.isTransactional();
    }

    public boolean marshallOutsideLatch() {
        return this.marshallBehavior.marshallOutsideLatch();
    }

    public boolean isReplicationPossible() {
        return this.replicationPossible.isReplicable();
    }

    public boolean isSyncPoint() {
        return this.replicationPossible.isMatchable();
    }

    public static boolean isSyncPoint(byte entryType) {
        return LogEntryType.findType(entryType).isSyncPoint();
    }

    static enum Marshall {
        OUTSIDE_LATCH(true),
        INSIDE_LATCH(false);

        private final boolean marshallOutsideLatch;

        private Marshall(boolean marshallOutsideLatch) {
            this.marshallOutsideLatch = marshallOutsideLatch;
        }

        boolean marshallOutsideLatch() {
            return this.marshallOutsideLatch;
        }
    }

    static enum Replicable {
        REPLICABLE_MATCH(true, true),
        REPLICABLE_NO_MATCH(true, false),
        LOCAL(false, false);

        private final boolean isReplicable;
        private final boolean isMatchable;

        private Replicable(boolean isReplicable, boolean isMatchable) {
            this.isReplicable = isReplicable;
            this.isMatchable = isMatchable;
        }

        boolean isReplicable() {
            return this.isReplicable;
        }

        boolean isMatchable() {
            return this.isMatchable;
        }
    }

    static enum Txnal {
        TXNAL(true),
        NON_TXNAL(false);

        private final boolean isTxnal;

        private Txnal(boolean isTxnal) {
            this.isTxnal = isTxnal;
        }

        boolean isTransactional() {
            return this.isTxnal;
        }
    }
}

