/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.tree.IN;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class SharedEvictor
extends Evictor {
    private static final int MIN_ROTATIONS = 10;
    private static final int INIT_SIZE_THRESHOLD = 10;
    private List<Subject> subjects = new ArrayList<Subject>();
    private int rotationIndex;
    private int trackerEvictionIndex;
    private boolean needInitSizes = true;
    private int smallestSize;
    private int totalSize;
    private AtomicInteger changedINs = new AtomicInteger();

    public SharedEvictor(EnvironmentImpl env, String name) throws DatabaseException {
        super(env, name);
    }

    @Override
    public void loadStats(StatsConfig config, EnvironmentStats stat) throws DatabaseException {
        stat.setNSharedCacheEnvironments(this.subjects.size());
        super.loadStats(config, stat);
    }

    @Override
    public void clearEnv() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void noteINListChange(int nINs) {
        if (this.changedINs.addAndGet(nINs) > this.totalSize / 10) {
            this.needInitSizes = true;
        }
    }

    @Override
    public synchronized void addEnvironment(EnvironmentImpl env) {
        int nSubjects = this.subjects.size();
        int i = 0;
        while (i < nSubjects) {
            Subject subject = this.subjects.get(i);
            if (subject.env == env) {
                return;
            }
            ++i;
        }
        Subject subject = new Subject();
        subject.env = env;
        subject.ins = env.getInMemoryINs();
        this.subjects.add(subject);
        this.needInitSizes = true;
    }

    @Override
    public synchronized void removeEnvironment(EnvironmentImpl env) {
        int nSubjects = this.subjects.size();
        int i = 0;
        while (i < nSubjects) {
            Subject subject = this.subjects.get(i);
            if (subject.env == env) {
                this.subjects.remove(i);
                this.needInitSizes = true;
                return;
            }
            ++i;
        }
    }

    @Override
    public boolean checkEnvs(Set<EnvironmentImpl> envs) {
        int nSubjects = this.subjects.size();
        if (nSubjects != envs.size()) {
            return false;
        }
        int i = 0;
        while (i < nSubjects) {
            Subject subject = this.subjects.get(i);
            if (!envs.contains(subject.env)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    Logger getLogger() {
        return null;
    }

    @Override
    long startBatch() throws DatabaseException {
        int nSubjects;
        if (this.needInitSizes) {
            this.initSizes();
        }
        if ((nSubjects = this.subjects.size()) > 0) {
            if (this.trackerEvictionIndex >= nSubjects) {
                this.trackerEvictionIndex = 0;
            }
            Subject subject = this.subjects.get(this.trackerEvictionIndex);
            ++this.trackerEvictionIndex;
            return subject.env.getUtilizationTracker().evictMemory();
        }
        return 0L;
    }

    @Override
    int getMaxINsPerBatch() {
        return this.totalSize;
    }

    @Override
    IN getNextIN() {
        int initialIndex = this.rotationIndex;
        int nSubjects = this.subjects.size();
        if (nSubjects == 0) {
            return null;
        }
        while (true) {
            if (this.rotationIndex >= nSubjects) {
                this.rotationIndex = 0;
            }
            Subject subject = this.subjects.get(this.rotationIndex);
            ++this.rotationIndex;
            if (subject.remaining > 0 && this.isEvictionAllowed(subject)) {
                subject.remaining -= this.smallestSize;
                if (subject.iter == null || !subject.iter.hasNext()) {
                    subject.iter = subject.ins.iterator();
                }
                if (subject.iter.hasNext()) {
                    return subject.iter.next();
                }
                subject.remaining = -1;
            }
            if (this.rotationIndex != initialIndex) continue;
            boolean foundAny = false;
            int i = 0;
            while (i < nSubjects) {
                Subject sub = this.subjects.get(i);
                if (sub.size > 0) {
                    sub.remaining = sub.size * 10;
                    if (this.isEvictionAllowed(sub)) {
                        foundAny = true;
                    }
                }
                ++i;
            }
            if (!foundAny) break;
        }
        return null;
    }

    private boolean isEvictionAllowed(Subject subject) {
        return subject.env.getMemoryBudget().isTreeUsageAboveMinimum();
    }

    private void initSizes() {
        this.totalSize = 0;
        this.smallestSize = Integer.MAX_VALUE;
        int nSubjects = this.subjects.size();
        int i = 0;
        while (i < nSubjects) {
            Subject subject = this.subjects.get(i);
            int size = subject.ins.getSize();
            if (this.smallestSize > size) {
                this.smallestSize = size;
            }
            this.totalSize += size;
            subject.size = size;
            subject.remaining = size * 10;
            ++i;
        }
        this.needInitSizes = false;
    }

    @Override
    Iterator<IN> getScanIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    void setScanIterator(Iterator<IN> iter) {
        throw new UnsupportedOperationException();
    }

    private static class Subject {
        EnvironmentImpl env;
        INList ins;
        Iterator<IN> iter;
        int size;
        int remaining;

        private Subject() {
        }
    }
}

