/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.OffsetList;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Arrays;
import java.util.List;

public class SortedLSNTreeWalker {
    protected DatabaseImpl dbImpl;
    private EnvironmentImpl envImpl;
    private long rootLsn;
    private boolean dups;
    private boolean setDbState;
    private long[] currentLSNs;
    private int currentLSNIdx = 0;
    private OffsetList accumulatedLSNFileNumbers;
    private OffsetList accumulatedLSNFileOffsets;
    private TreeNodeProcessor callback;
    protected boolean accumulateLNs = false;
    private boolean processDupTree = true;
    private boolean passNullLSNNodes = false;
    private List<DatabaseException> savedExceptions;
    private ExceptionPredicate excPredicate;
    private DatabaseEntry lnKeyEntry = new DatabaseEntry();
    public boolean didSomeMore = false;

    public SortedLSNTreeWalker(DatabaseImpl dbImpl, boolean setDbState, long rootLsn, TreeNodeProcessor callback, List<DatabaseException> savedExceptions, ExceptionPredicate excPredicate) throws DatabaseException {
        this.dbImpl = dbImpl;
        this.envImpl = dbImpl.getDbEnvironment();
        if (this.envImpl == null) {
            throw new DatabaseException("environmentImpl is null for target db " + dbImpl.getDebugName());
        }
        this.dups = dbImpl.getSortedDuplicates();
        this.setDbState = setDbState;
        this.rootLsn = rootLsn;
        this.callback = callback;
        this.savedExceptions = savedExceptions;
        this.excPredicate = excPredicate;
        this.currentLSNs = new long[0];
        this.currentLSNIdx = 0;
    }

    void setProcessDupTree(boolean processDupTree) {
        this.processDupTree = processDupTree;
    }

    void setPassNullLSNNodes(boolean passNullLSNNodes) {
        this.passNullLSNNodes = passNullLSNNodes;
    }

    void setAccumulateLNs(boolean accumulateLNs) {
        this.accumulateLNs = accumulateLNs;
    }

    public void walk() throws DatabaseException {
        this.walkInternal();
    }

    protected void walkInternal() throws DatabaseException {
        IN root = null;
        if (this.rootLsn == -1L && !this.passNullLSNNodes) {
            return;
        }
        root = this.getResidentRootIN();
        if (root == null && this.rootLsn != -1L) {
            root = this.getRootIN(this.rootLsn);
        }
        if (root != null) {
            this.accumulateLSNs(root);
            this.releaseRootIN(root);
        }
        if (this.setDbState) {
            this.dbImpl.finishedINListHarvest();
        }
        while (true) {
            this.maybeGetMoreINs();
            if (this.currentLSNs == null || this.currentLSNIdx >= this.currentLSNs.length) break;
            this.didSomeMore = true;
            this.fetchAndProcessLSN(this.currentLSNs[this.currentLSNIdx++]);
        }
    }

    private void maybeGetMoreINs() {
        if (this.currentLSNs != null && this.currentLSNIdx >= this.currentLSNs.length) {
            if (this.accumulatedLSNFileNumbers == null || this.accumulatedLSNFileNumbers.size() == 0) {
                this.currentLSNs = null;
                this.currentLSNIdx = Integer.MAX_VALUE;
                return;
            }
            long[] tempFileNumbers = this.accumulatedLSNFileNumbers.toArray();
            long[] tempFileOffsets = this.accumulatedLSNFileOffsets.toArray();
            int nLSNs = tempFileNumbers.length;
            this.currentLSNIdx = 0;
            this.currentLSNs = new long[nLSNs];
            int i = 0;
            while (i < nLSNs) {
                this.currentLSNs[i] = DbLsn.makeLsn(tempFileNumbers[i], tempFileOffsets[i]);
                ++i;
            }
            Arrays.sort(this.currentLSNs);
            this.accumulatedLSNFileNumbers = null;
            this.accumulatedLSNFileOffsets = null;
        }
    }

    private void accumulateLSNs(IN in) throws DatabaseException {
        boolean isDINRoot;
        boolean childIsLN;
        boolean accumulate = true;
        boolean bl = childIsLN = !this.dups && in instanceof BIN || in instanceof DBIN;
        if (childIsLN && !this.accumulateLNs) {
            accumulate = false;
        }
        boolean bl2 = isDINRoot = in instanceof DIN && in.isRoot();
        if (in != null && (this.processDupTree || !in.containsDuplicates())) {
            int i = 0;
            while (i < in.getNEntries()) {
                long lsn = in.getLsn(i);
                Node node = in.getTarget(i);
                if (in.isEntryPendingDeleted(i) || in.isEntryKnownDeleted(i)) {
                    LN ln;
                    if (node instanceof LN && (ln = (LN)node).isDirty()) {
                        this.callback.processDirtyDeletedLN(lsn, ln, in.getKey(i));
                    }
                } else if (accumulate && node == null && lsn != -1L) {
                    if (this.accumulatedLSNFileNumbers == null) {
                        this.accumulatedLSNFileNumbers = new OffsetList();
                        this.accumulatedLSNFileOffsets = new OffsetList();
                    }
                    this.accumulatedLSNFileNumbers.add(DbLsn.getFileNumber(lsn), false);
                    this.accumulatedLSNFileOffsets.add(DbLsn.getFileOffset(lsn), false);
                    this.addToLsnINMap(lsn, in, i);
                } else if (lsn != -1L || this.passNullLSNNodes) {
                    byte[] lnKey = (byte[])(node == null || node instanceof LN ? in.getKey(i) : null);
                    this.callback.processLSN(lsn, node == null ? LogEntryType.LOG_LN : node.getLogType(), node, lnKey);
                    if (node instanceof IN) {
                        IN nodeAsIN = (IN)node;
                        try {
                            nodeAsIN.latch(CacheMode.UNCHANGED);
                            this.accumulateLSNs(nodeAsIN);
                        }
                        finally {
                            nodeAsIN.releaseLatch();
                        }
                    }
                }
                ++i;
            }
        }
        if (isDINRoot) {
            DIN din = (DIN)in;
            ChildReference dupCountLNRef = din.getDupCountLNRef();
            long lsn = dupCountLNRef.getLsn();
            if (lsn == -1L) {
                DupCountLN dcl = din.getDupCountLN();
                this.callback.processDupCount(dcl.getDupCount());
            } else {
                this.addToLsnINMap(lsn, in, -1);
                Node node = this.fetchLSN(lsn, this.lnKeyEntry);
                this.callback.processLSN(lsn, LogEntryType.LOG_DUPCOUNTLN, node, dupCountLNRef.getKey());
            }
        }
    }

    private void fetchAndProcessLSN(long lsn) throws DatabaseException {
        block10: {
            try {
                this.lnKeyEntry.setData(null);
                Node node = this.fetchLSN(lsn, this.lnKeyEntry);
                boolean isIN = node instanceof IN;
                IN in = null;
                try {
                    if (isIN) {
                        in = (IN)node;
                        in.latch(CacheMode.UNCHANGED);
                    }
                    if (node != null) {
                        this.callback.processLSN(lsn, node.getLogType(), node, this.lnKeyEntry.getData());
                        if (isIN) {
                            this.accumulateLSNs(in);
                        }
                    }
                }
                finally {
                    if (isIN) {
                        in.releaseLatch();
                    }
                }
            }
            catch (DatabaseException e) {
                if (this.excPredicate != null && this.excPredicate.ignoreException(e)) break block10;
                if (this.savedExceptions != null) {
                    this.savedExceptions.add(e);
                }
                throw e;
            }
        }
    }

    protected IN getRootIN(long rootLsn) throws DatabaseException {
        return (IN)this.envImpl.getLogManager().get(rootLsn);
    }

    protected IN getResidentRootIN() throws DatabaseException {
        return this.dbImpl.getTree().getResidentRootIN(false);
    }

    protected void releaseRootIN(IN ignore) throws DatabaseException {
    }

    protected void addToLsnINMap(Long lsn, IN in, int index) {
    }

    protected Node fetchLSN(long lsn, DatabaseEntry lnKeyEntry) throws DatabaseException {
        LogEntry entry = this.envImpl.getLogManager().getLogEntry(lsn);
        if (entry instanceof LNLogEntry) {
            lnKeyEntry.setData(((LNLogEntry)entry).getKey());
        }
        return (Node)entry.getMainItem();
    }

    public List<DatabaseException> getSavedExceptions() {
        return this.savedExceptions;
    }

    public static interface ExceptionPredicate {
        public boolean ignoreException(Exception var1);
    }

    public static interface TreeNodeProcessor {
        public void processLSN(long var1, LogEntryType var3, Node var4, byte[] var5) throws DatabaseException;

        public void processDirtyDeletedLN(long var1, LN var3, byte[] var4) throws DatabaseException;

        public void processDupCount(int var1);
    }
}

