/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.BaseLocalUtilizationTracker;
import com.sleepycat.je.cleaner.DbFileSummaryMap;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogFileNotFoundException;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.utilint.DbLsn;
import java.util.HashMap;
import java.util.Map;

public class RecoveryUtilizationTracker
extends BaseLocalUtilizationTracker {
    private Map<Long, Long> fileSummaryLsns = new HashMap<Long, Long>();
    private Map<DatabaseId, Long> databaseLsns = new HashMap<DatabaseId, Long>();

    public RecoveryUtilizationTracker(EnvironmentImpl env) throws DatabaseException {
        super(env, new HashMap<Object, DbFileSummaryMap>());
    }

    public void saveLastLoggedFileSummaryLN(long fileNum, long lsn) {
        this.fileSummaryLsns.put(fileNum, lsn);
    }

    public void saveLastLoggedMapLN(DatabaseId dbId, long lsn) {
        this.databaseLsns.put(dbId, lsn);
    }

    public void countNewLogEntry(long lsn, LogEntryType type, int size, DatabaseId dbId) {
        this.countNew(lsn, dbId, type, size);
    }

    public void countObsoleteUnconditional(long lsn, LogEntryType type, int size, DatabaseId dbId, boolean countExact) {
        this.countObsolete(lsn, dbId, type, size, true, true, countExact);
    }

    public boolean countObsoleteIfUncounted(long oldLsn, long newLsn, LogEntryType type, int size, DatabaseId dbId, boolean countExact) {
        Long fileNum = DbLsn.getFileNumber(oldLsn);
        boolean fileUncounted = this.isFileUncounted(fileNum, newLsn);
        boolean dbUncounted = this.isDbUncounted(dbId, newLsn);
        this.countObsolete(oldLsn, dbId, type, size, fileUncounted, dbUncounted, countExact);
        return fileUncounted;
    }

    public int fetchLNSize(int size, long lsn) throws DatabaseException {
        if (size == 0 && this.env.getCleaner().getFetchObsoleteSize()) {
            try {
                LN ln = (LN)this.env.getLogManager().get(lsn);
                size = ln.getLastLoggedSize();
            }
            catch (LogFileNotFoundException logFileNotFoundException) {
                // empty catch block
            }
        }
        return size;
    }

    @Override
    boolean isFileUncounted(Long fileNum, long lsn) {
        int cmpFsLsnToNewLsn;
        long fsLsn = DbLsn.longToLsn(this.fileSummaryLsns.get(fileNum));
        int n = cmpFsLsnToNewLsn = fsLsn != -1L ? DbLsn.compareTo(fsLsn, lsn) : -1;
        return cmpFsLsnToNewLsn < 0;
    }

    private boolean isDbUncounted(DatabaseId dbId, long lsn) {
        int cmpDbLsnToLsn;
        long dbLsn = DbLsn.longToLsn(this.databaseLsns.get(dbId));
        int n = cmpDbLsnToLsn = dbLsn != -1L ? DbLsn.compareTo(dbLsn, lsn) : -1;
        return cmpDbLsnToLsn < 0;
    }

    public void resetFileInfo(long fileNum) {
        TrackedFileSummary trackedSummary = this.getTrackedFile(fileNum);
        if (trackedSummary != null) {
            trackedSummary.reset();
        }
    }

    public void resetDbInfo(DatabaseId dbId) {
        this.removeDbFileSummaries(dbId);
    }

    @Override
    DatabaseImpl databaseKeyToDatabaseImpl(Object databaseKey) throws DatabaseException {
        DatabaseId dbId = (DatabaseId)databaseKey;
        return this.env.getDbTree().getDb(dbId);
    }

    @Override
    void releaseDatabaseImpl(DatabaseImpl db) {
        this.env.getDbTree().releaseDb(db);
    }
}

