/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.ForeignKeyDeleteAction;
import com.sleepycat.je.ForeignKeyNullifier;
import com.sleepycat.je.ForeignKeyTrigger;
import com.sleepycat.je.ForeignMultiKeyNullifier;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.JoinCursor;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.je.SecondaryKeyCreator;
import com.sleepycat.je.SecondaryMultiKeyCreator;
import com.sleepycat.je.SecondaryTrigger;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.utilint.DatabaseUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SecondaryDatabase
extends Database {
    private static final Set<DatabaseEntry> EMPTY_SET = Collections.emptySet();
    private Database primaryDb;
    private SecondaryConfig secondaryConfig;
    private SecondaryTrigger secondaryTrigger;
    private ForeignKeyTrigger foreignKeyTrigger;

    SecondaryDatabase(Environment env, SecondaryConfig secConfig, Database primaryDatabase) throws DatabaseException {
        super(env);
        Database foreignDb;
        DatabaseUtil.checkForNullParam(primaryDatabase, "primaryDatabase");
        primaryDatabase.checkRequiredDbState(OPEN, "Can't use as primary:");
        if (primaryDatabase.configuration.getSortedDuplicates()) {
            throw new IllegalArgumentException("Duplicates must not be allowed for a primary database: " + primaryDatabase.getDebugName());
        }
        if (env.getEnvironmentImpl() != primaryDatabase.getEnvironment().getEnvironmentImpl()) {
            throw new IllegalArgumentException("Primary and secondary databases must be in the same environment");
        }
        if (secConfig.getKeyCreator() != null && secConfig.getMultiKeyCreator() != null) {
            throw new IllegalArgumentException("secConfig.getKeyCreator() and getMultiKeyCreator() may not both be non-null");
        }
        if (!primaryDatabase.configuration.getReadOnly() && secConfig.getKeyCreator() == null && secConfig.getMultiKeyCreator() == null) {
            throw new NullPointerException("secConfig and getKeyCreator()/getMultiKeyCreator() may be null only if the primary database is read-only");
        }
        if (secConfig.getForeignKeyNullifier() != null && secConfig.getForeignMultiKeyNullifier() != null) {
            throw new IllegalArgumentException("secConfig.getForeignKeyNullifier() and getForeignMultiKeyNullifier() may not both be non-null");
        }
        if (secConfig.getForeignKeyDeleteAction() == ForeignKeyDeleteAction.NULLIFY && secConfig.getForeignKeyNullifier() == null && secConfig.getForeignMultiKeyNullifier() == null) {
            throw new NullPointerException("ForeignKeyNullifier or ForeignMultiKeyNullifier must be non-null when ForeignKeyDeleteAction is NULLIFY");
        }
        if (secConfig.getForeignKeyNullifier() != null && secConfig.getMultiKeyCreator() != null) {
            throw new IllegalArgumentException("ForeignKeyNullifier may not be used with SecondaryMultiKeyCreator -- use ForeignMultiKeyNullifier instead");
        }
        if (secConfig.getForeignKeyDatabase() != null && (foreignDb = secConfig.getForeignKeyDatabase()).getDatabaseImpl().getSortedDuplicates()) {
            throw new IllegalArgumentException("Duplicates must not be allowed for a foreign key  database: " + foreignDb.getDebugName());
        }
        this.primaryDb = primaryDatabase;
        this.secondaryTrigger = new SecondaryTrigger(this);
        if (secConfig.getForeignKeyDatabase() != null) {
            this.foreignKeyTrigger = new ForeignKeyTrigger(this);
        }
    }

    @Override
    void initNew(Environment env, Locker locker, String databaseName, DatabaseConfig dbConfig) throws DatabaseException {
        super.initNew(env, locker, databaseName, dbConfig);
        this.init(locker);
    }

    @Override
    void initExisting(Environment env, Locker locker, DatabaseImpl database, DatabaseConfig dbConfig) throws DatabaseException {
        Database otherPriDb = database.findPrimaryDatabase();
        if (otherPriDb != null && otherPriDb.getDatabaseImpl() != this.primaryDb.getDatabaseImpl()) {
            throw new IllegalArgumentException("Secondary is already associated with a different primary: " + otherPriDb.getDebugName());
        }
        super.initExisting(env, locker, database, dbConfig);
        this.init(locker);
    }

    private void init(Locker locker) throws DatabaseException {
        this.trace(Level.FINEST, "SecondaryDatabase open");
        this.secondaryConfig = (SecondaryConfig)this.configuration;
        this.primaryDb.addTrigger(this.secondaryTrigger, false);
        Database foreignDb = this.secondaryConfig.getForeignKeyDatabase();
        if (foreignDb != null) {
            foreignDb.addTrigger(this.foreignKeyTrigger, true);
        }
        if (this.secondaryConfig.getAllowPopulate()) {
            Cursor secCursor = null;
            Cursor priCursor = null;
            try {
                secCursor = new Cursor((Database)this, locker, null);
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                OperationStatus status = secCursor.position(key, data, LockMode.DEFAULT, true);
                if (status == OperationStatus.NOTFOUND) {
                    priCursor = new Cursor(this.primaryDb, locker, null);
                    status = priCursor.position(key, data, LockMode.DEFAULT, true);
                    while (status == OperationStatus.SUCCESS) {
                        this.updateSecondary(locker, secCursor, key, null, data);
                        status = priCursor.retrieveNext(key, data, LockMode.DEFAULT, GetMode.NEXT);
                    }
                }
            }
            finally {
                if (secCursor != null) {
                    secCursor.close();
                }
                if (priCursor != null) {
                    priCursor.close();
                }
            }
        }
    }

    @Override
    public synchronized void close() throws DatabaseException {
        Database foreignDb;
        if (this.primaryDb != null && this.secondaryTrigger != null) {
            this.primaryDb.removeTrigger(this.secondaryTrigger);
        }
        if ((foreignDb = this.secondaryConfig.getForeignKeyDatabase()) != null && this.foreignKeyTrigger != null) {
            foreignDb.removeTrigger(this.foreignKeyTrigger);
        }
        super.close();
    }

    void clearPrimary() {
        this.primaryDb = null;
        this.secondaryTrigger = null;
    }

    void clearForeignKeyTrigger() {
        this.foreignKeyTrigger = null;
    }

    public Database getPrimaryDatabase() throws DatabaseException {
        return this.primaryDb;
    }

    public SecondaryConfig getSecondaryConfig() throws DatabaseException {
        return (SecondaryConfig)this.getConfig();
    }

    public SecondaryConfig getPrivateSecondaryConfig() {
        return this.secondaryConfig;
    }

    public SecondaryCursor openSecondaryCursor(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        return (SecondaryCursor)this.openCursor(txn, cursorConfig);
    }

    @Override
    Cursor newDbcInstance(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        return new SecondaryCursor(this, txn, cursorConfig);
    }

    @Override
    public OperationStatus delete(Transaction txn, DatabaseEntry key) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        this.checkRequiredDbState(OPEN, "Can't call SecondaryDatabase.delete:");
        this.trace(Level.FINEST, "SecondaryDatabase.delete", txn, key, null, null);
        Locker locker = null;
        Cursor cursor = null;
        OperationStatus commitStatus = OperationStatus.NOTFOUND;
        try {
            locker = LockerFactory.getWritableLocker(this.envHandle, txn, this.isTransactional(), this.getDatabaseImpl().isReplicated());
            cursor = new Cursor((Database)this, locker, null);
            DatabaseEntry pKey = new DatabaseEntry();
            OperationStatus searchStatus = cursor.search(key, pKey, LockMode.RMW, CursorImpl.SearchMode.SET);
            while (searchStatus == OperationStatus.SUCCESS) {
                commitStatus = this.primaryDb.deleteInternal(locker, pKey, null);
                if (commitStatus != OperationStatus.SUCCESS) {
                    throw this.secondaryCorruptException();
                }
                searchStatus = cursor.retrieveNext(key, pKey, LockMode.RMW, GetMode.NEXT_DUP);
            }
            OperationStatus operationStatus = commitStatus;
            return operationStatus;
        }
        catch (Error E) {
            DbInternal.envGetEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                locker.operationEnd(commitStatus);
            }
        }
    }

    @Override
    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.get(txn, key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.checkRequiredDbState(OPEN, "Can't call SecondaryDatabase.get:");
        this.trace(Level.FINEST, "SecondaryDatabase.get", txn, key, null, lockMode);
        CursorConfig cursorConfig = CursorConfig.DEFAULT;
        if (lockMode == LockMode.READ_COMMITTED) {
            cursorConfig = CursorConfig.READ_COMMITTED;
            lockMode = null;
        }
        Cursor cursor = null;
        try {
            cursor = new SecondaryCursor(this, txn, cursorConfig);
            OperationStatus operationStatus = ((SecondaryCursor)cursor).search(key, pKey, data, lockMode, CursorImpl.SearchMode.SET);
            return operationStatus;
        }
        catch (Error E) {
            DbInternal.envGetEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @Override
    public OperationStatus getSearchBoth(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus getSearchBoth(Transaction txn, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.checkRequiredDbState(OPEN, "Can't call SecondaryDatabase.getSearchBoth:");
        this.trace(Level.FINEST, "SecondaryDatabase.getSearchBoth", txn, key, data, lockMode);
        CursorConfig cursorConfig = CursorConfig.DEFAULT;
        if (lockMode == LockMode.READ_COMMITTED) {
            cursorConfig = CursorConfig.READ_COMMITTED;
            lockMode = null;
        }
        Cursor cursor = null;
        try {
            cursor = new SecondaryCursor(this, txn, cursorConfig);
            OperationStatus operationStatus = ((SecondaryCursor)cursor).search(key, pKey, data, lockMode, CursorImpl.SearchMode.BOTH);
            return operationStatus;
        }
        catch (Error E) {
            DbInternal.envGetEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @Override
    public OperationStatus put(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus putNoOverwrite(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus putNoDupData(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public JoinCursor join(Cursor[] cursors, JoinConfig config) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void updateSecondary(Locker locker, Cursor cursor, DatabaseEntry priKey, DatabaseEntry oldData, DatabaseEntry newData) throws DatabaseException {
        boolean localCursor;
        if (this.secondaryConfig.getImmutableSecondaryKey() && oldData != null && newData != null) {
            return;
        }
        SecondaryKeyCreator keyCreator = this.secondaryConfig.getKeyCreator();
        if (keyCreator != null) {
            boolean localCursor2;
            assert (this.secondaryConfig.getMultiKeyCreator() == null);
            DatabaseEntry oldSecKey = null;
            if (oldData != null && !keyCreator.createSecondaryKey(this, priKey, oldData, oldSecKey = new DatabaseEntry())) {
                oldSecKey = null;
            }
            DatabaseEntry newSecKey = null;
            if (newData != null && !keyCreator.createSecondaryKey(this, priKey, newData, newSecKey = new DatabaseEntry())) {
                newSecKey = null;
            }
            if ((oldSecKey == null || oldSecKey.equals(newSecKey)) && (newSecKey == null || newSecKey.equals(oldSecKey))) return;
            boolean bl = localCursor2 = cursor == null;
            if (localCursor2) {
                cursor = new Cursor((Database)this, locker, null);
            }
            try {
                if (oldSecKey != null) {
                    this.deleteKey(cursor, priKey, oldSecKey);
                }
                if (newSecKey == null) return;
                this.insertKey(locker, cursor, priKey, newSecKey);
                return;
            }
            finally {
                if (localCursor2 && cursor != null) {
                    cursor.close();
                }
            }
        }
        SecondaryMultiKeyCreator multiKeyCreator = this.secondaryConfig.getMultiKeyCreator();
        assert (multiKeyCreator != null);
        Set<DatabaseEntry> oldKeys = EMPTY_SET;
        Set<DatabaseEntry> newKeys = EMPTY_SET;
        if (oldData != null) {
            oldKeys = new HashSet<DatabaseEntry>();
            multiKeyCreator.createSecondaryKeys(this, priKey, oldData, oldKeys);
        }
        if (newData != null) {
            newKeys = new HashSet<DatabaseEntry>();
            multiKeyCreator.createSecondaryKeys(this, priKey, newData, newKeys);
        }
        if (oldKeys.equals(newKeys)) return;
        boolean bl = localCursor = cursor == null;
        if (localCursor) {
            cursor = new Cursor((Database)this, locker, null);
        }
        try {
            Set<DatabaseEntry> oldKeysCopy = oldKeys;
            if (oldKeys != EMPTY_SET) {
                oldKeysCopy = new HashSet<DatabaseEntry>(oldKeys);
                oldKeys.removeAll(newKeys);
                for (DatabaseEntry oldKey : oldKeys) {
                    this.deleteKey(cursor, priKey, oldKey);
                }
            }
            if (newKeys == EMPTY_SET) return;
            newKeys.removeAll(oldKeysCopy);
            for (DatabaseEntry newKey : newKeys) {
                this.insertKey(locker, cursor, priKey, newKey);
            }
            return;
        }
        finally {
            if (localCursor && cursor != null) {
                cursor.close();
            }
        }
    }

    private void deleteKey(Cursor cursor, DatabaseEntry priKey, DatabaseEntry oldSecKey) throws DatabaseException {
        OperationStatus status = cursor.search(oldSecKey, priKey, LockMode.RMW, CursorImpl.SearchMode.BOTH);
        if (status != OperationStatus.SUCCESS) {
            throw new DatabaseException("Secondary " + this.getDebugName() + " is corrupt: the primary record contains a key" + " that is not present in the secondary");
        }
        cursor.deleteInternal();
    }

    private void insertKey(Locker locker, Cursor cursor, DatabaseEntry priKey, DatabaseEntry newSecKey) throws DatabaseException {
        OperationStatus status;
        Database foreignDb = this.secondaryConfig.getForeignKeyDatabase();
        if (foreignDb != null) {
            Cursor foreignCursor = null;
            try {
                foreignCursor = new Cursor(foreignDb, locker, null);
                DatabaseEntry tmpData = new DatabaseEntry();
                OperationStatus status2 = foreignCursor.search(newSecKey, tmpData, LockMode.DEFAULT, CursorImpl.SearchMode.SET);
                if (status2 != OperationStatus.SUCCESS) {
                    throw new DatabaseException("Secondary " + this.getDebugName() + " foreign key not allowed: it is not" + " present in the foreign database " + foreignDb.getDebugName());
                }
            }
            finally {
                if (foreignCursor != null) {
                    foreignCursor.close();
                }
            }
        }
        if ((status = this.configuration.getSortedDuplicates() ? cursor.putInternal(newSecKey, priKey, PutMode.NODUP) : cursor.putInternal(newSecKey, priKey, PutMode.NOOVERWRITE)) != OperationStatus.SUCCESS) {
            throw new DatabaseException("Could not insert secondary key in " + this.getDebugName() + ' ' + status);
        }
    }

    void onForeignKeyDelete(Locker locker, DatabaseEntry secKey) throws DatabaseException {
        ForeignKeyDeleteAction deleteAction = this.secondaryConfig.getForeignKeyDeleteAction();
        LockMode lockMode = deleteAction == ForeignKeyDeleteAction.ABORT ? LockMode.DEFAULT : LockMode.RMW;
        DatabaseEntry priKey = new DatabaseEntry();
        Cursor cursor = null;
        try {
            cursor = new Cursor((Database)this, locker, null);
            OperationStatus status = cursor.search(secKey, priKey, lockMode, CursorImpl.SearchMode.SET);
            while (status == OperationStatus.SUCCESS) {
                block22: {
                    DatabaseEntry data;
                    Cursor priCursor;
                    if (deleteAction == ForeignKeyDeleteAction.ABORT) {
                        throw new DatabaseException("Secondary " + this.getDebugName() + " refers to a foreign key that has been deleted" + " (ForeignKeyDeleteAction.ABORT)");
                    }
                    if (deleteAction == ForeignKeyDeleteAction.CASCADE) {
                        priCursor = null;
                        try {
                            data = new DatabaseEntry();
                            priCursor = new Cursor(this.primaryDb, locker, null);
                            status = priCursor.search(priKey, data, LockMode.RMW, CursorImpl.SearchMode.SET);
                            if (status == OperationStatus.SUCCESS) {
                                priCursor.delete();
                                break block22;
                            }
                            throw this.secondaryCorruptException();
                        }
                        finally {
                            if (priCursor != null) {
                                priCursor.close();
                            }
                        }
                    }
                    if (deleteAction == ForeignKeyDeleteAction.NULLIFY) {
                        priCursor = null;
                        try {
                            data = new DatabaseEntry();
                            priCursor = new Cursor(this.primaryDb, locker, null);
                            status = priCursor.search(priKey, data, LockMode.RMW, CursorImpl.SearchMode.SET);
                            if (status == OperationStatus.SUCCESS) {
                                ForeignMultiKeyNullifier multiNullifier = this.secondaryConfig.getForeignMultiKeyNullifier();
                                if (multiNullifier != null) {
                                    if (multiNullifier.nullifyForeignKey(this, priKey, data, secKey)) {
                                        priCursor.putCurrent(data);
                                    }
                                } else {
                                    ForeignKeyNullifier nullifier = this.secondaryConfig.getForeignKeyNullifier();
                                    if (nullifier.nullifyForeignKey(this, data)) {
                                        priCursor.putCurrent(data);
                                    }
                                }
                                break block22;
                            }
                            throw this.secondaryCorruptException();
                        }
                        finally {
                            if (priCursor != null) {
                                priCursor.close();
                            }
                        }
                    }
                    throw new IllegalStateException();
                }
                status = cursor.retrieveNext(secKey, priKey, LockMode.DEFAULT, GetMode.NEXT_DUP);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    DatabaseException secondaryCorruptException() throws DatabaseException {
        throw new DatabaseException("Secondary " + this.getDebugName() + " is corrupt: it refers" + " to a missing key in the primary database");
    }

    static UnsupportedOperationException notAllowedException() {
        throw new UnsupportedOperationException("Operation not allowed on a secondary");
    }

    void trace(Level level, String methodName) throws DatabaseException {
        Logger logger = this.envHandle.getEnvironmentImpl().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(methodName);
            sb.append(" name=").append(this.getDebugName());
            sb.append(" primary=").append(this.primaryDb.getDebugName());
            logger.log(level, sb.toString());
        }
    }
}

