/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.RecordNumberBinding;
import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.BlockIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.PrimaryKeyAssigner;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.util.keyrange.KeyRangeException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class StoredList<E>
extends StoredCollection<E>
implements List<E> {
    private static final EntryBinding DEFAULT_KEY_BINDING = new IndexKeyBinding(1);
    private int baseIndex = 1;
    private boolean isSubList;

    public StoredList(Database database, EntryBinding<E> valueBinding, boolean writeAllowed) {
        super(new DataView(database, DEFAULT_KEY_BINDING, valueBinding, null, writeAllowed, null));
    }

    public StoredList(Database database, EntityBinding<E> valueEntityBinding, boolean writeAllowed) {
        super(new DataView(database, DEFAULT_KEY_BINDING, null, valueEntityBinding, writeAllowed, null));
    }

    public StoredList(Database database, EntryBinding<E> valueBinding, PrimaryKeyAssigner keyAssigner) {
        super(new DataView(database, DEFAULT_KEY_BINDING, valueBinding, null, true, keyAssigner));
    }

    public StoredList(Database database, EntityBinding<E> valueEntityBinding, PrimaryKeyAssigner keyAssigner) {
        super(new DataView(database, DEFAULT_KEY_BINDING, null, valueEntityBinding, true, keyAssigner));
    }

    private StoredList(DataView view, int baseIndex) {
        super(view);
        this.baseIndex = baseIndex;
        this.isSubList = true;
    }

    @Override
    public void add(int index, E value) {
        this.checkIterAddAllowed();
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            OperationStatus status = cursor.getSearchKey(index, null, false);
            if (status == OperationStatus.SUCCESS) {
                cursor.putBefore(value);
                this.closeCursor(cursor);
            } else {
                this.closeCursor(cursor);
                cursor = null;
                this.view.append(value, null, null);
            }
            this.commitAutoCommit(doAutoCommit);
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public boolean add(E value) {
        this.checkIterAddAllowed();
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            this.view.append(value, null, null);
            this.commitAutoCommit(doAutoCommit);
            return true;
        }
        catch (Exception e) {
            throw this.handleException(e, doAutoCommit);
        }
    }

    public int append(E value) {
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            Object[] key = new Object[1];
            this.view.append(value, key, null);
            this.commitAutoCommit(doAutoCommit);
            return ((Number)key[0]).intValue();
        }
        catch (Exception e) {
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (this.isSubList) {
            throw new UnsupportedOperationException("cannot add to subList");
        }
        if (!this.view.keysRenumbered) {
            throw new UnsupportedOperationException("requires renumbered keys");
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> coll) {
        boolean doAutoCommit;
        Iterator i;
        DataCursor cursor;
        block7: {
            this.checkIterAddAllowed();
            cursor = null;
            i = null;
            doAutoCommit = this.beginAutoCommit();
            i = this.storedOrExternalIterator(coll);
            if (i.hasNext()) break block7;
            return false;
        }
        try {
            cursor = new DataCursor(this.view, true);
            OperationStatus status = cursor.getSearchKey(index, null, false);
            if (status == OperationStatus.SUCCESS) {
                while (i.hasNext()) {
                    cursor.putBefore(i.next());
                }
                this.closeCursor(cursor);
            } else {
                this.closeCursor(cursor);
                cursor = null;
                while (i.hasNext()) {
                    this.view.append(i.next(), null, null);
                }
            }
            StoredIterator.close(i);
            this.commitAutoCommit(doAutoCommit);
            return true;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            StoredIterator.close(i);
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public E get(int index) {
        return (E)this.getValue(index);
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, true);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.indexOf(value, false);
    }

    private int indexOf(Object value, boolean findFirst) {
        int n;
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            OperationStatus status = cursor.findValue(value, findFirst);
            n = status == OperationStatus.SUCCESS ? cursor.getCurrentRecordNumber() - this.baseIndex : -1;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return n;
    }

    @Override
    int getIndexOffset() {
        return this.baseIndex;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.blockIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        BlockIterator i = this.blockIterator();
        if (i.moveToIndex(index)) {
            return i;
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    @Override
    public E remove(int index) {
        try {
            Object[] oldVal = new Object[1];
            this.removeKey(index, oldVal);
            return (E)oldVal[0];
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public boolean remove(Object value) {
        return this.removeValue(value);
    }

    @Override
    public E set(int index, E value) {
        try {
            return (E)this.putKeyValue(index, value);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException(String.valueOf(fromIndex));
        }
        try {
            int newBaseIndex = this.baseIndex + fromIndex;
            return new StoredList<E>(this.view.subView(fromIndex, true, toIndex, false, new IndexKeyBinding(newBaseIndex)), newBaseIndex);
        }
        catch (KeyRangeException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof List)) {
            return false;
        }
        List otherList = (List)other;
        StoredIterator i1 = null;
        ListIterator i2 = null;
        try {
            i1 = this.storedIterator();
            i2 = this.storedOrExternalListIterator(otherList);
            if (i1.hasNext()) {
            }
            return !i2.hasNext();
            {
            }
        }
        finally {
            if (i1 != null) {
                i1.close();
            }
            StoredIterator.close(i2);
        }
    }

    final ListIterator storedOrExternalListIterator(List list) {
        if (list instanceof StoredCollection) {
            return ((StoredCollection)((Object)list)).storedIterator();
        }
        return list.listIterator();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    E makeIteratorData(BaseIterator iterator, DatabaseEntry keyEntry, DatabaseEntry priKeyEntry, DatabaseEntry valueEntry) {
        return (E)this.view.makeValue(priKeyEntry, valueEntry);
    }

    @Override
    boolean hasValues() {
        return true;
    }

    private static class IndexKeyBinding
    extends RecordNumberBinding {
        private int baseIndex;

        private IndexKeyBinding(int baseIndex) {
            this.baseIndex = baseIndex;
        }

        @Override
        public Long entryToObject(DatabaseEntry data) {
            return IndexKeyBinding.entryToRecordNumber(data) - (long)this.baseIndex;
        }

        @Override
        public void objectToEntry(Long object, DatabaseEntry data) {
            IndexKeyBinding.recordNumberToEntry(((Number)object).intValue() + this.baseIndex, data);
        }
    }
}

