/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.cache.memcached.route.strategy;

import com.lenovo.vctl.dal.cache.config.model.KeyPatternItem;
import com.lenovo.vctl.dal.cache.exception.StrategyException;
import com.lenovo.vctl.dal.cache.memcached.config.helper.CacheConfigHelper;
import com.lenovo.vctl.dal.cache.route.strategy.IStrategy;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultStrategy
implements IStrategy {
    private static Logger logger = Logger.getLogger(DefaultStrategy.class);

    @Override
    public Object playStrategy(String regionName, Object key) throws StrategyException {
        if (StringUtils.isEmpty((String)regionName)) {
            throw new StrategyException("region name must have a value");
        }
        if (key == null) {
            throw new StrategyException("key must have a value");
        }
        Map<String, KeyPatternItem> keyPatternMap = CacheConfigHelper.getKeyKeyPatternItems(regionName);
        if (MapUtils.isEmpty(keyPatternMap)) {
            logger.warn((Object)("don't find KeyPatternItems of the " + regionName + " , begin use default set!"));
            keyPatternMap = CacheConfigHelper.getDefaultKeyKeyPatternItems();
        }
        if (MapUtils.isNotEmpty(keyPatternMap)) {
            KeyPatternItem keyPatternItem = this.findPatternItem(keyPatternMap, key);
            return keyPatternItem != null ? keyPatternItem.getDatasource() : null;
        }
        return null;
    }

    private KeyPatternItem findPatternItem(Map<String, KeyPatternItem> patternMap, Object key) {
        KeyPatternItem patternItem = null;
        Collection<KeyPatternItem> patternItems = patternMap.values();
        for (KeyPatternItem item : patternItems) {
            Pattern pattern;
            String value;
            if (item == null || !StringUtils.isNotEmpty((String)(value = item.getValue())) || !(pattern = Pattern.compile(value)).matcher(ObjectUtils.toString((Object)key)).find()) continue;
            patternItem = item;
            break;
        }
        return patternItem != null ? patternItem : patternItems.iterator().next();
    }
}

