/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.cache.memcached.notify;

import com.lenovo.vctl.dal.cache.Cache;
import com.lenovo.vctl.dal.cache.memcached.CacheFactoryImpl;
import com.lenovo.vctl.dal.cache.memcached.channel.source.MemcachedSource;
import com.lenovo.vctl.dal.cache.memcached.client.MemCachedClientImpl;
import com.lenovo.vctl.dal.cache.memcached.config.helper.CacheConfigHelper;
import com.lenovo.vctl.dal.cache.memcached.notify.model.Message;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Server {
    private static Map<String, Boolean> modifyMethods = new HashMap<String, Boolean>();
    private static Logger logger;
    private static ExecutorService executorService;

    static {
        modifyMethods.put("delete", Boolean.TRUE);
        modifyMethods.put("save", Boolean.TRUE);
        modifyMethods.put("remove", Boolean.TRUE);
        modifyMethods.put("update", Boolean.TRUE);
        modifyMethods.put("incr", Boolean.TRUE);
        modifyMethods.put("decr", Boolean.TRUE);
        modifyMethods.put("ladd", Boolean.TRUE);
        modifyMethods.put("radd", Boolean.TRUE);
        modifyMethods.put("setList", Boolean.TRUE);
        modifyMethods.put("removeList", Boolean.TRUE);
        logger = Logger.getLogger(Server.class);
        executorService = Executors.newFixedThreadPool(1);
    }

    public static void main(String[] args) {
        MemcachedSource source = CacheConfigHelper.getDefaultQueueMemcachedSource();
        if (source != null) {
            MemCachedClientImpl client = new MemCachedClientImpl(source);
            while (true) {
                String eventData;
                if (StringUtils.isNotBlank((String)(eventData = (String)client.get("listener")))) {
                    final Message message = new Message(eventData);
                    System.out.println(message);
                    executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            Server.processMessage(message);
                        }
                    });
                    continue;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        System.out.println("don't find queue default memcachedsource");
    }

    private static void processMessage(Message message) {
        Cache cache;
        if (message != null && (cache = CacheFactoryImpl.getInstance().getCache(message.getRegionName(), true)) != null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)message);
                }
                if (Server.isModifyMethod(message.getMethodName())) {
                    cache.remove(message.getKeys());
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)(" the method " + message.getMethodName() + " don't process"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isModifyMethod(String methodName) {
        if (StringUtils.isNotBlank((String)methodName)) {
            return modifyMethods.get(methodName) != null;
        }
        return false;
    }
}

