/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.cache.binding.classcatalog;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.util.UtfOps;
import java.io.ObjectStreamClass;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SNSClassCatalog
implements ClassCatalog {
    private static Logger logger = Logger.getLogger(SNSClassCatalog.class);
    private static Map<String, ObjectStreamClass> idToDescMap = new ConcurrentHashMap<String, ObjectStreamClass>();
    private static Map<String, byte[]> nameToIdMap = new ConcurrentHashMap<String, byte[]>();

    static {
        SNSClassCatalog.registerClassInfo(Boolean.class.getName());
        SNSClassCatalog.registerClassInfo(Byte.class.getName());
        SNSClassCatalog.registerClassInfo(Character.class.getName());
        SNSClassCatalog.registerClassInfo(Double.class.getName());
        SNSClassCatalog.registerClassInfo(Float.class.getName());
        SNSClassCatalog.registerClassInfo(Integer.class.getName());
        SNSClassCatalog.registerClassInfo(Short.class.getName());
        SNSClassCatalog.registerClassInfo(String.class.getName());
        SNSClassCatalog.registerClassInfo(Long.class.getName());
        SNSClassCatalog.registerClassInfo(Number.class.getName());
    }

    @Override
    public void close() throws DatabaseException {
    }

    @Override
    public ObjectStreamClass getClassFormat(byte[] classID) throws DatabaseException, ClassNotFoundException {
        String strId = new String(classID);
        ObjectStreamClass desc = idToDescMap.get(strId);
        if (desc == null) {
            logger.error((Object)(String.valueOf(strId) + " don't find id, please registerClassInfo, Auto register"));
            desc = SNSClassCatalog.getObjectStreamClass(strId);
            if (desc != null) {
                SNSClassCatalog.registerClassInfo(strId);
            }
        }
        return desc;
    }

    @Override
    public byte[] getClassID(ObjectStreamClass classDesc) throws DatabaseException, ClassNotFoundException {
        String className = classDesc.getName();
        byte[] id = nameToIdMap.get(className);
        if (id == null) {
            logger.error((Object)(String.valueOf(className) + " don't find id, please registerClassInfo, Auto register"));
            id = SNSClassCatalog.getByte(className);
            if (id != null) {
                SNSClassCatalog.registerClassInfo(className);
            }
        }
        return id;
    }

    public static void registerClassInfo(String className) {
        if (StringUtils.isNotEmpty((String)className)) {
            if (nameToIdMap.containsKey(className)) {
                logger.warn((Object)(String.valueOf(className) + " " + " exist!, please don't register it"));
            } else {
                ObjectStreamClass osc = SNSClassCatalog.getObjectStreamClass(className);
                if (osc != null) {
                    byte[] id = SNSClassCatalog.getByte(className);
                    nameToIdMap.put(className, id);
                    idToDescMap.put(new String(id), osc);
                }
            }
        } else {
            logger.error((Object)"clazzname is null or tempty");
        }
    }

    private static byte[] getByte(String className) {
        char[] nameChars = className.toCharArray();
        byte[] keyBytes = new byte[UtfOps.getByteLength(nameChars)];
        UtfOps.charsToBytes(nameChars, 0, keyBytes, 0, nameChars.length);
        return keyBytes;
    }

    private static ObjectStreamClass getObjectStreamClass(String className) {
        Class<?> clazz = null;
        ObjectStreamClass osc = null;
        try {
            clazz = Class.forName(className);
            osc = ObjectStreamClass.lookup(clazz);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage());
        }
        return osc;
    }

    public static void main(String[] args) {
        System.out.println(SNSClassCatalog.getObjectStreamClass("com.sohu.test.model.Personal"));
    }
}

