/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.dao.util;

public class MinHeap {
    private Object[][] heap;
    private int maxsize;
    private int size;

    public MinHeap(int max, int objSize) {
        this.maxsize = max + 1;
        this.heap = new Object[this.maxsize][objSize];
        this.size = 0;
        Object[] baseObjArray = new Object[objSize];
        int i = 0;
        while (i < objSize) {
            baseObjArray[i] = -1L;
            ++i;
        }
        this.heap[0] = baseObjArray;
    }

    private int leftchild(int pos) {
        return 2 * pos;
    }

    private int rightchild(int pos) {
        return 2 * pos + 1;
    }

    private int parent(int pos) {
        return pos / 2;
    }

    private boolean isleaf(int pos) {
        return pos > this.size / 2 && pos <= this.size;
    }

    private void swap(int pos1, int pos2) {
        Object[] tmp = this.heap[pos1];
        this.heap[pos1] = this.heap[pos2];
        this.heap[pos2] = tmp;
    }

    public void insert(Object[] objs) {
        this.heap[++this.size] = objs;
        int current = this.size;
        Long newValue = new Long("" + this.heap[current][objs.length - 1]);
        Long parentValue = new Long("" + this.heap[this.parent(current)][objs.length - 1]);
        while (newValue < parentValue) {
            this.swap(current, this.parent(current));
            current = this.parent(current);
            newValue = new Long("" + this.heap[current][objs.length - 1]);
            parentValue = new Long("" + this.heap[this.parent(current)][objs.length - 1]);
        }
    }

    public Object[] removemin() {
        this.swap(1, this.size);
        if (--this.size != 0) {
            this.pushdown(1);
        }
        return this.heap[this.size + 1];
    }

    public Object[] minvalue() {
        return this.size > 0 ? this.heap[1] : this.heap[0];
    }

    public int size() {
        return this.size;
    }

    private void pushdown(int position) {
        while (!this.isleaf(position)) {
            int smallestchild = this.leftchild(position);
            if (smallestchild < this.size && this.getOrderedValue(smallestchild) > this.getOrderedValue(smallestchild + 1)) {
                ++smallestchild;
            }
            if (this.getOrderedValue(position) <= this.getOrderedValue(smallestchild)) {
                return;
            }
            this.swap(position, smallestchild);
            position = smallestchild;
        }
    }

    public Long getOrderedValue(int position) {
        Object[] obs = this.heap[position];
        Long value = new Long("" + obs[obs.length - 1]);
        return value;
    }

    public void print() {
        int i = 1;
        while (i <= this.size) {
            int j = 0;
            while (j < this.heap[i].length) {
                System.out.print(this.heap[i][j] + " ");
                ++j;
            }
            System.out.print("\n");
            ++i;
        }
        System.out.print("\n");
    }
}

