/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.dao.util;

import com.lenovo.vctl.dal.dao.config.helper.DaoHelper;
import com.lenovo.vctl.dal.dao.config.model.dao.MapItem;
import com.lenovo.vctl.dal.dao.exception.DaoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.hibernate.SessionFactory;

public class DalAssert {
    public static void assertObjectIllegal(Object userId, Object obj) throws DaoException {
        if (userId != null && obj != null) {
            Method method = DaoHelper.getStrategyPropertyMethod(obj.getClass().getName());
            if (method == null) {
                throw new DaoException(200, "Error: method doesn't found");
            }
            Object requiredId = null;
            try {
                requiredId = method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            if (requiredId != null && !requiredId.equals(userId)) {
                throw new DaoException(100, "Error: The account_id doesn't match the object strategy propertyDetail: userId --" + userId + " obj's userId --" + requiredId + "\r\n");
            }
        }
    }

    public static void assertListIllegal(Object userId, List list) throws DaoException {
        if (userId != null && list != null && list.size() > 0) {
            int i = 0;
            while (i < list.size()) {
                DalAssert.assertObjectIllegal(userId, list.get(i));
                ++i;
            }
        }
    }

    public static void assertClassTypeNotNull(Class cls) throws DaoException {
        if (cls == null) {
            throw new DaoException(300);
        }
    }

    public static void assertObjectNotNull(Object obj) throws DaoException {
        if (obj == null) {
            throw new DaoException(301);
        }
    }

    public static void assertObjectNotNull(List obs) throws DaoException {
        if (obs == null) {
            throw new DaoException(301);
        }
        if (obs.size() == 0) {
            throw new DaoException(301);
        }
        for (Object obj : obs) {
            if (obj != null) continue;
            throw new DaoException(301);
        }
    }

    public static void assertObjectNotNull(Object obj, String description) throws DaoException {
        if (obj == null) {
            throw new DaoException(303, description);
        }
    }

    public static void assertSessionFactoryNotNull(SessionFactory sessionFactory) throws DaoException {
        if (sessionFactory == null) {
            throw new DaoException(302);
        }
    }

    public static void assertDaoMapException(MapItem mapItem) throws DaoException {
        if (mapItem == null) {
            throw new DaoException(304);
        }
        if (mapItem.getSqlitem() == null) {
            throw new DaoException(305);
        }
    }

    public static void assertTwoListEquals(List list1, List list2) throws DaoException {
        if (list1.size() != list2.size()) {
            throw new DaoException(402);
        }
    }
}

