/*
 * Decompiled with CFR 0.152.
 */
package com.jiabangou.mtwmsdk.api.impl;

import com.alibaba.fastjson.JSONObject;
import com.jiabangou.mtwmsdk.api.LogListener;
import com.jiabangou.mtwmsdk.api.MtWmConfigStorage;
import com.jiabangou.mtwmsdk.api.ShopService;
import com.jiabangou.mtwmsdk.api.impl.BaseServiceImpl;
import com.jiabangou.mtwmsdk.exception.MtWmErrorException;
import com.jiabangou.mtwmsdk.model.Additional;
import com.jiabangou.mtwmsdk.model.Comment;
import com.jiabangou.mtwmsdk.model.Qualify;
import com.jiabangou.mtwmsdk.model.Shop;
import com.jiabangou.mtwmsdk.model.ShopTag;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.CloseableHttpClient;

public class ShopServiceImplImpl
extends BaseServiceImpl
implements ShopService {
    private static final String POI_SAVE = "/poi/save";
    private static final String POI_GETIDS = "/poi/getids";
    private static final String POI_MGET = "/poi/mget";
    private static final String POI_OPEN = "/poi/open";
    private static final String POI_CLOSE = "/poi/close";
    private static final String POI_OFFLINE = "/poi/offline";
    private static final String POI_ONLINE = "/poi/online";
    private static final String POI_QUALIFY_SAVE = "/poi/qualify/save";
    private static final String POI_SENDTIME_SAVE = "/poi/sendtime/save";
    private static final String POI_ADDITIONAL_SAVE = "/poi/additional/save";
    private static final String POI_UPDATEPROMOTEINFO = "/poi/updatepromoteinfo";
    private static final String POITAG_LIST = "/poiTag/list";
    private static final String POI_SHIPPINGTIME_UPDATE = "/poi/shippingtime/update";
    private static final String POI_COMMENT = "/poi/comment/app_poi_code";
    private static final String POI_COMMENT_ADD_REPLY = "/poi/comment/add_reply";

    public ShopServiceImplImpl(MtWmConfigStorage mtWmConfigStorage, CloseableHttpClient httpClient, HttpHost httpProxy, LogListener listener, boolean isTest) {
        super(mtWmConfigStorage, httpClient, httpProxy, listener, isTest);
    }

    @Override
    public void save(Shop shop) throws MtWmErrorException {
        this.doPost(POI_SAVE, shop);
    }

    @Override
    public List<String> getIds() throws MtWmErrorException {
        JSONObject jsonObject = this.doGet(POI_GETIDS);
        return this.getList(jsonObject, "data", String.class);
    }

    @Override
    public List<Shop> gets(List<String> appPoiCodes) throws MtWmErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_poi_codes", StringUtils.join(appPoiCodes, (String)","));
        JSONObject jsonObject = this.doGet(POI_MGET, params);
        return this.getList(jsonObject, "data", Shop.class);
    }

    @Override
    public void open(String id) throws MtWmErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_poi_code", id);
        this.doPost(POI_OPEN, params);
    }

    @Override
    public void close(String id) throws MtWmErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_poi_code", id);
        this.doPost(POI_CLOSE, params);
    }

    @Override
    public void offline(String id, String reason) throws MtWmErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_poi_code", id);
        params.put("reason", reason);
        this.doPost(POI_OFFLINE, params);
    }

    @Override
    public void online(String id) throws MtWmErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_poi_code", id);
        this.doPost(POI_ONLINE, params);
    }

    @Override
    public void saveQualify(Qualify qualify) throws MtWmErrorException {
        this.doPost(POI_QUALIFY_SAVE, qualify);
    }

    @Override
    public void saveSendtime(List<String> appPoiCodes, int sendTime) throws MtWmErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_poi_codes", StringUtils.join(appPoiCodes, (String)","));
        params.put("send_time", String.valueOf(sendTime));
        this.doPost(POI_SENDTIME_SAVE, params);
    }

    @Override
    public void saveAdditional(Additional additional) throws MtWmErrorException {
        this.doPost(POI_ADDITIONAL_SAVE, additional);
    }

    @Override
    public void updatePromote(String appPoiCode, String promotion) throws MtWmErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_poi_code", appPoiCode);
        params.put("promotion_info", promotion);
        this.doPost(POI_UPDATEPROMOTEINFO, params);
    }

    @Override
    public List<ShopTag> getShopTags() throws MtWmErrorException {
        JSONObject jsonObject = this.doGet(POITAG_LIST);
        return this.getList(jsonObject, "data", ShopTag.class);
    }

    @Override
    public void updateShippingTime(String appPoiCode, String shippingTime) throws MtWmErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_poi_code", appPoiCode);
        params.put("shipping_time", shippingTime);
        this.doPost(POI_SHIPPINGTIME_UPDATE, params);
    }

    @Override
    public List<Comment> getShopComment(String appPoiCode, String startTime, String endTime, int pageSize) throws MtWmErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_poi_code", appPoiCode);
        params.put("start_time", startTime);
        params.put("end_time", endTime);
        params.put("pagesize", String.valueOf(pageSize));
        params.put("pageoffset", "20");
        JSONObject jsonObject = this.doGet(POI_COMMENT, params);
        return this.getList(jsonObject, "data", Comment.class);
    }

    @Override
    public void replyShopComment(String orderId, String commentId, String content) throws MtWmErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_poi_code", orderId);
        params.put("comment_id", commentId);
        params.put("reply", content);
        this.doPost(POI_COMMENT_ADD_REPLY, params);
    }
}

