/*
 * Decompiled with CFR 0.152.
 */
package com.jiabangou.mtwmsdk.api.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.jiabangou.mtwmsdk.api.LogListener;
import com.jiabangou.mtwmsdk.api.MtWmConfigStorage;
import com.jiabangou.mtwmsdk.api.ShippingService;
import com.jiabangou.mtwmsdk.api.impl.BaseServiceImpl;
import com.jiabangou.mtwmsdk.exception.MtWmErrorException;
import com.jiabangou.mtwmsdk.model.Shipping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.CloseableHttpClient;

public class ShippingServiceImpl
extends BaseServiceImpl
implements ShippingService {
    private static final String SHIPPING_SAVE = "/shipping/save";
    private static final String SHIPPING_LIST = "/shipping/list";
    private static final String SHIPPING_BATCHSAVE = "/shipping/batchsave";

    public ShippingServiceImpl(MtWmConfigStorage mtWmConfigStorage, CloseableHttpClient httpClient, HttpHost httpProxy, LogListener listener, boolean isTest) {
        super(mtWmConfigStorage, httpClient, httpProxy, listener, isTest);
    }

    @Override
    public void save(String appPoiCode, Shipping shipping) throws MtWmErrorException {
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)shipping);
        JSONArray jsonAreaArray = jsonObject.getJSONArray("area");
        for (Object object : jsonAreaArray) {
            JSONObject jsonObjectTemp = (JSONObject)JSON.toJSON(object);
            jsonObjectTemp.put("x", (Object)((long)(jsonObjectTemp.getDoubleValue("x") * 1000000.0)));
            jsonObjectTemp.put("y", (Object)((long)(jsonObjectTemp.getDoubleValue("y") * 1000000.0)));
        }
        jsonObject.put("area", (Object)JSONObject.toJSONString((Object)jsonAreaArray));
        this.doPost(SHIPPING_SAVE, jsonObject);
    }

    @Override
    public List<Shipping> getsByAppPoiCode(String appPoiCode) throws MtWmErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_poi_code", appPoiCode);
        JSONArray jsonArray = this.doGet(SHIPPING_LIST, params).getJSONArray("data");
        ArrayList<Shipping> list = new ArrayList<Shipping>();
        for (Object obj : jsonArray) {
            JSONObject jsonObjectTemp = (JSONObject)obj;
            jsonObjectTemp.put("area", (Object)JSON.parseArray((String)jsonObjectTemp.getString("area")));
            JSONArray jsonAreaArray = jsonObjectTemp.getJSONArray("area");
            for (Object object : jsonAreaArray) {
                JSONObject jsonAreaObjectTemp = (JSONObject)JSON.toJSON(object);
                jsonAreaObjectTemp.put("x", (Object)(jsonAreaObjectTemp.getDoubleValue("x") / 1000000.0));
                jsonAreaObjectTemp.put("y", (Object)(jsonAreaObjectTemp.getDoubleValue("y") / 1000000.0));
            }
            list.add((Shipping)TypeUtils.castToJavaBean((Object)jsonObjectTemp, Shipping.class));
        }
        return list;
    }

    @Override
    public void batchSave(String appPoiCode, List<Shipping> shippings) throws MtWmErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_poi_code", appPoiCode);
        params.put("shipping_data", JSON.toJSON(shippings).toString());
        this.doPost(SHIPPING_BATCHSAVE, params);
    }
}

