/*
 * Decompiled with CFR 0.152.
 */
package com.jiabangou.mtwmsdk.api.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.jiabangou.mtwmsdk.api.FoodService;
import com.jiabangou.mtwmsdk.api.ImageService;
import com.jiabangou.mtwmsdk.api.LogListener;
import com.jiabangou.mtwmsdk.api.MtWmClient;
import com.jiabangou.mtwmsdk.api.MtWmConfigStorage;
import com.jiabangou.mtwmsdk.api.OrderService;
import com.jiabangou.mtwmsdk.api.PushConsumer;
import com.jiabangou.mtwmsdk.api.ShippingService;
import com.jiabangou.mtwmsdk.api.ShopService;
import com.jiabangou.mtwmsdk.api.impl.FoodServiceImpl;
import com.jiabangou.mtwmsdk.api.impl.ImageServiceImpl;
import com.jiabangou.mtwmsdk.api.impl.OrderServiceImpl;
import com.jiabangou.mtwmsdk.api.impl.ShippingServiceImpl;
import com.jiabangou.mtwmsdk.api.impl.ShopServiceImplImpl;
import com.jiabangou.mtwmsdk.exception.MtWmErrorException;
import com.jiabangou.mtwmsdk.model.Order;
import com.jiabangou.mtwmsdk.model.OrderDetail;
import com.jiabangou.mtwmsdk.model.ResultMessage;
import com.jiabangou.mtwmsdk.utils.MtWmUtils;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public class MtWmClientImpl
implements MtWmClient {
    private MtWmConfigStorage configStorage;
    private LogListener logListener;
    private PushConsumer pushConsumer;
    private CloseableHttpClient httpClient;
    private HttpHost httpProxy;
    private FoodService foodService;
    private ShopService shopService;
    private OrderService orderService;
    private ShippingService shippingService;
    private ImageService imageService;
    private Boolean isTest = false;

    public MtWmClientImpl() {
    }

    public MtWmClientImpl(MtWmConfigStorage configStorage) {
        this.configStorage = configStorage;
    }

    @Override
    public void setConfigStorage(MtWmConfigStorage configStorage) {
        this.configStorage = configStorage;
        String http_proxy_host = configStorage.getHttp_proxy_host();
        int http_proxy_port = configStorage.getHttp_proxy_port();
        String http_proxy_username = configStorage.getHttp_proxy_username();
        String http_proxy_password = configStorage.getHttp_proxy_password();
        HttpClientBuilder builder = HttpClients.custom();
        if (StringUtils.isNotBlank((String)http_proxy_host)) {
            if (StringUtils.isNotBlank((String)http_proxy_username)) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(http_proxy_host, http_proxy_port), (Credentials)new UsernamePasswordCredentials(http_proxy_username, http_proxy_password));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            this.httpProxy = new HttpHost(http_proxy_host, http_proxy_port);
        }
        this.httpClient = builder.build();
    }

    @Override
    public void setLogListener(LogListener logListener) {
        this.logListener = logListener;
    }

    @Override
    public void setPushConsumer(PushConsumer pushConsumer) {
        this.pushConsumer = pushConsumer;
    }

    @Override
    public void setIsTest(Boolean isTest) {
        this.isTest = isTest;
    }

    @Override
    public ResultMessage pushHandle(String url, Map<String, String> params, String pushAction) {
        if (this.pushConsumer == null) {
            return new ResultMessage("pushConsumer does not implement");
        }
        params = MtWmUtils.urlDecodeParams(params);
        String httpMethod = "";
        try {
            MtWmUtils.sigCheck(url, params, this.configStorage.getAppId(), this.configStorage.getSecret());
        }
        catch (Exception e) {
            this.logging(pushAction, httpMethod, false, JSON.toJSONString(params), e.getMessage());
            return new ResultMessage(e.getMessage());
        }
        try {
            if ("create_order".equals(pushAction)) {
                OrderDetail orderDetail = this.getOrderDetail(params);
                this.pushConsumer.createOrder(orderDetail);
                httpMethod = "POST";
            } else if ("confirmed_order".equals(pushAction)) {
                OrderDetail orderDetail = this.getOrderDetail(params);
                this.pushConsumer.confirmedOrder(orderDetail);
                httpMethod = "POST";
            } else if ("completed_order".equals(pushAction)) {
                OrderDetail orderDetail = this.getOrderDetail(params);
                this.pushConsumer.completedOrder(orderDetail);
                httpMethod = "POST";
            } else if ("cancel_order".equals(pushAction)) {
                this.pushConsumer.cancelOrder(params.get("order_id"), Integer.valueOf(params.get("reason_code")), params.get("reason"));
                httpMethod = "GET";
            } else if ("refund_order".equals(pushAction)) {
                String orderId = params.get("order_id");
                String notifyType = params.get("notify_type");
                String reason = params.get("reason");
                this.pushConsumer.refundOrder(orderId, notifyType, reason);
                httpMethod = "GET";
            } else if ("logistics_status".equals(pushAction)) {
                String orderId = params.get("order_id");
                Short statusCode = Short.valueOf(params.get("logistics_status"));
                String time = params.get("time");
                String dispatcherName = params.get("dispatcher_name");
                String dispatcherMobile = params.get("dispatcher_mobile");
                this.pushConsumer.deliveryStatus(orderId, statusCode, time, dispatcherName, dispatcherMobile);
                httpMethod = "POST";
            }
        }
        catch (MtWmErrorException e) {
            this.logging(pushAction, httpMethod, false, JSON.toJSONString(params), e.getMessage());
        }
        this.logging(pushAction, httpMethod, true, JSON.toJSONString(params), JSON.toJSONString((Object)ResultMessage.buildOk()));
        return ResultMessage.buildOk();
    }

    private OrderDetail getOrderDetail(Map<String, String> params) throws MtWmErrorException {
        OrderService orderService = this.getOrderService();
        return orderService.getOrderDetail(params.get("order_id"), Short.valueOf("1"));
    }

    private Order getOrder(Map<String, String> params) {
        JSONObject jsonObjectTemp = JSONObject.parseObject((String)JSON.toJSONString(params));
        jsonObjectTemp.put("detail", (Object)JSON.parseArray((String)jsonObjectTemp.getString("detail")));
        jsonObjectTemp.put("extras", (Object)JSON.parseArray((String)jsonObjectTemp.getString("extras")));
        return (Order)TypeUtils.castToJavaBean((Object)jsonObjectTemp, Order.class);
    }

    private void logging(String cmd, String method, boolean isSuccess, String request, String response) {
        if (this.logListener != null) {
            this.logListener.requestEvent(cmd, method, isSuccess, request, response);
        }
    }

    @Override
    public ShopService getShopService() {
        if (this.shopService == null) {
            this.shopService = new ShopServiceImplImpl(this.configStorage, this.httpClient, this.httpProxy, this.logListener, this.isTest);
        }
        return this.shopService;
    }

    @Override
    public ShippingService getShippingService() {
        if (this.shippingService == null) {
            this.shippingService = new ShippingServiceImpl(this.configStorage, this.httpClient, this.httpProxy, this.logListener, this.isTest);
        }
        return this.shippingService;
    }

    @Override
    public FoodService getFoodService() {
        if (this.foodService == null) {
            this.foodService = new FoodServiceImpl(this.configStorage, this.httpClient, this.httpProxy, this.logListener, this.isTest);
        }
        return this.foodService;
    }

    @Override
    public OrderService getOrderService() {
        if (this.orderService == null) {
            this.orderService = new OrderServiceImpl(this.configStorage, this.httpClient, this.httpProxy, this.logListener, this.isTest);
        }
        return this.orderService;
    }

    @Override
    public ImageService getImageService() {
        if (this.imageService == null) {
            this.imageService = new ImageServiceImpl(this.configStorage, this.httpClient, this.httpProxy, this.logListener, this.isTest);
        }
        return this.imageService;
    }
}

