/*
 * Decompiled with CFR 0.152.
 */
package com.jiabangou.mtwmsdk.api.impl;

import com.jiabangou.mtwmsdk.api.ImageService;
import com.jiabangou.mtwmsdk.api.LogListener;
import com.jiabangou.mtwmsdk.api.MtWmConfigStorage;
import com.jiabangou.mtwmsdk.api.impl.BaseServiceImpl;
import com.jiabangou.mtwmsdk.exception.MtWmErrorException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.CloseableHttpClient;

public class ImageServiceImpl
extends BaseServiceImpl
implements ImageService {
    private static final String IMAGE_UPLOAD = "/image/upload";

    public ImageServiceImpl(MtWmConfigStorage mtWmConfigStorage, CloseableHttpClient httpClient, HttpHost httpProxy, LogListener listener, boolean isTest) {
        super(mtWmConfigStorage, httpClient, httpProxy, listener, isTest);
    }

    @Override
    public String uploadImage(String appPoiCode, String imgName, byte[] imgData) throws MtWmErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_poi_code", appPoiCode);
        params.put("img_name", imgName);
        return this.doPost(IMAGE_UPLOAD, params, imgName, imgData).getString("data");
    }

    @Override
    public String uploadImage(String appPoiCode, String imgName, String imgUrl) throws MtWmErrorException {
        byte[] imgData = this.getImageData(imgUrl);
        return this.uploadImage(appPoiCode, imgName, imgData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getImageData(String destUrl) {
        byte[] content = null;
        try {
            BufferedInputStream bis = null;
            ByteArrayOutputStream out = null;
            HttpURLConnection httpUrl = null;
            byte[] buf = new byte[2046];
            try {
                int len;
                URL url = new URL(destUrl);
                httpUrl = (HttpURLConnection)url.openConnection();
                httpUrl.connect();
                bis = new BufferedInputStream(httpUrl.getInputStream());
                out = new ByteArrayOutputStream();
                while ((len = bis.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                content = out.toByteArray();
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
                if (out != null) {
                    out.close();
                }
                if (httpUrl != null) {
                    httpUrl.disconnect();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }
}

