/*
 * Decompiled with CFR 0.152.
 */
package com.jiabangou.mtwmsdk.api.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.jiabangou.mtwmsdk.api.LogListener;
import com.jiabangou.mtwmsdk.api.MtWmConfigStorage;
import com.jiabangou.mtwmsdk.exception.MtWmError;
import com.jiabangou.mtwmsdk.exception.MtWmErrorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class BaseServiceImpl {
    public static final String API_URL = "http://waimaiopen.meituan.com/api/v1";
    public static final String TEST_API_URL = "http://test.waimaiopen.meituan.com/api/v1";
    public static final String UTF_8 = "UTF-8";
    public static final String DATA = "data";
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_METHOD_POST = "POST";
    protected MtWmConfigStorage mtWmConfigStorage;
    protected HttpHost httpProxy;
    protected CloseableHttpClient httpClient;
    protected LogListener logListener;
    protected boolean isTest;

    public BaseServiceImpl(MtWmConfigStorage mtWmConfigStorage, CloseableHttpClient httpClient, HttpHost httpProxy, LogListener logListener, boolean isTest) {
        this.mtWmConfigStorage = mtWmConfigStorage;
        this.httpClient = httpClient;
        this.httpProxy = httpProxy;
        this.logListener = logListener;
        this.isTest = isTest;
    }

    private void logging(String cmd, String method, boolean isSuccess, String request, String response) {
        if (this.logListener != null) {
            this.logListener.requestEvent(cmd, method, isSuccess, request, response);
        }
    }

    protected String getBaseApiUrl() {
        return this.isTest ? TEST_API_URL : API_URL;
    }

    protected String createApiSignature(String url, Map params, int timestamp) {
        HashMap signMap = new HashMap(params);
        ArrayList list = new ArrayList(signMap.keySet());
        Collections.sort(list);
        StringBuilder stringBuilder = new StringBuilder(url);
        stringBuilder.append("?");
        for (int i = 0; i < list.size(); ++i) {
            Object value = signMap.get(list.get(i));
            if (value instanceof byte[] || value == null) continue;
            stringBuilder.append((String)list.get(i)).append("=").append(value.toString());
            if (i >= list.size() - 1) continue;
            stringBuilder.append("&");
        }
        stringBuilder.append(this.mtWmConfigStorage.getSecret());
        return DigestUtils.md5Hex((String)stringBuilder.toString());
    }

    protected JSONObject doGet(String url) throws MtWmErrorException {
        return this.doGet(url, null);
    }

    protected JSONObject doGet(String url, Object params) throws MtWmErrorException {
        try {
            return this.getResponseJsonObject(HTTP_METHOD_GET, url, params);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected JSONObject doPost(String url) throws MtWmErrorException {
        return this.doPost(url, null);
    }

    protected JSONObject doPost(String url, Object params) throws MtWmErrorException {
        try {
            return this.getResponseJsonObject(HTTP_METHOD_POST, url, params);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JSONObject getResponseJsonObject(String httpMethod, String url, Object params) throws IOException, MtWmErrorException {
        HttpGet httpUriRequest = null;
        String fullUrl = this.getBaseApiUrl() + url;
        List<NameValuePair> sysNameValuePairs = this.getSysNameValuePairs(fullUrl, params);
        List<NameValuePair> nameValuePairs = this.getNameValuePairs(params);
        if (HTTP_METHOD_GET.equals(httpMethod)) {
            sysNameValuePairs.addAll(nameValuePairs);
            HttpGet httpGet = new HttpGet(fullUrl + "?" + URLEncodedUtils.format(sysNameValuePairs, (String)UTF_8));
            this.setRequestConfig((HttpRequestBase)httpGet);
            httpUriRequest = httpGet;
        } else if (HTTP_METHOD_POST.equals(httpMethod)) {
            HttpPost httpPost = new HttpPost(fullUrl + "?" + URLEncodedUtils.format(sysNameValuePairs, (String)UTF_8));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, UTF_8));
            this.setRequestConfig((HttpRequestBase)httpPost);
            httpUriRequest = httpPost;
        }
        CloseableHttpResponse response = this.httpClient.execute(httpUriRequest);
        String resultContent = new BasicResponseHandler().handleResponse((HttpResponse)response);
        JSONObject jsonObject = JSON.parseObject((String)resultContent);
        MtWmError error = MtWmError.fromJson(jsonObject);
        if (error != null) {
            this.logging(url, httpMethod, false, httpUriRequest.getURI() + "\nBody:" + JSON.toJSONString((Object)params), resultContent);
            throw new MtWmErrorException(error.getErrorCode(), error.getErrorMsg());
        }
        this.logging(url, httpMethod, true, httpUriRequest.getURI() + "\nBody:" + JSON.toJSONString((Object)params), resultContent);
        return jsonObject;
    }

    protected JSONObject doPost(String url, Object params, String imageName, byte[] fileData) throws MtWmErrorException {
        try {
            return this.getResponseJsonObject(HTTP_METHOD_POST, url, params, imageName, fileData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JSONObject getResponseJsonObject(String httpMethod, String url, Object params, String imageName, byte[] fileData) throws IOException, MtWmErrorException {
        String fullUrl = this.getBaseApiUrl() + url;
        List<NameValuePair> sysNameValuePairs = this.getSysNameValuePairs(fullUrl, params);
        List<NameValuePair> nameValuePairs = this.getNameValuePairs(params);
        HttpPost httpPost = new HttpPost(fullUrl + "?" + URLEncodedUtils.format(sysNameValuePairs, (String)UTF_8));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        for (NameValuePair p : nameValuePairs) {
            builder.addTextBody(p.getName(), p.getValue(), ContentType.TEXT_PLAIN.withCharset(UTF_8));
        }
        builder.addPart("img_data", (ContentBody)new ByteArrayBody(fileData, imageName));
        HttpEntity entity = builder.build();
        httpPost.addHeader(entity.getContentType());
        httpPost.setEntity(entity);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
        String resultContent = new BasicResponseHandler().handleResponse((HttpResponse)response);
        JSONObject jsonObject = JSON.parseObject((String)resultContent);
        MtWmError error = MtWmError.fromJson(jsonObject);
        if (error != null) {
            this.logging(url, httpMethod, false, httpPost.getURI() + "\nBody:" + JSON.toJSONString((Object)params), resultContent);
            throw new MtWmErrorException(error.getErrorCode(), error.getErrorMsg());
        }
        this.logging(url, httpMethod, true, httpPost.getURI() + "\nBody:" + JSON.toJSONString((Object)params), resultContent);
        return jsonObject;
    }

    private List<NameValuePair> getSysNameValuePairs(String url, Object params) {
        Map<Object, Object> beanMap = params != null ? this.getParamsMap(params) : new HashMap();
        int timestamp = (int)(System.currentTimeMillis() / 1000L);
        beanMap.put("app_id", this.mtWmConfigStorage.getAppId());
        beanMap.put("timestamp", String.valueOf(timestamp));
        beanMap.put("sig", this.createApiSignature(url, beanMap, timestamp));
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("app_id", (String)beanMap.get("app_id")));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("timestamp", (String)beanMap.get("timestamp")));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("sig", (String)beanMap.get("sig")));
        return nameValuePairs;
    }

    private List<NameValuePair> getNameValuePairs(Object params) {
        Map<Object, Object> beanMap = params != null ? this.getParamsMap(params) : new HashMap();
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        for (Map.Entry<Object, Object> entry : beanMap.entrySet()) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair(entry.getKey().toString(), entry.getValue().toString()));
        }
        return nameValuePairs;
    }

    protected Map<String, String> getParamsMap(Object obj) {
        JSONObject jsonObject = (JSONObject)JSONObject.toJSON((Object)obj);
        HashMap<String, String> params = new HashMap<String, String>();
        jsonObject.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> params.put((String)entry.getKey(), TypeUtils.castToString(entry.getValue())));
        return params;
    }

    private void setRequestConfig(HttpRequestBase httpRequestBase) {
        if (this.httpProxy != null) {
            httpRequestBase.setConfig(RequestConfig.custom().setProxy(this.httpProxy).build());
        }
    }

    protected <T> List<T> getList(JSONObject jsonObject, String key, Class<T> clazz) {
        JSONArray jsonArray = jsonObject.getJSONArray(key);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : jsonArray) {
            list.add(TypeUtils.castToJavaBean(obj, clazz));
        }
        return list;
    }

    protected <T> T get(JSONObject jsonObject, String key, Class<T> clazz) {
        JSONObject obj = jsonObject.getJSONObject(key);
        return (T)TypeUtils.castToJavaBean((Object)obj, clazz);
    }
}

