/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.utils;

import com.jamonapi.utils.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class SerializationUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Serializable object, OutputStream outputStream) throws IOException {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(outputStream);
            out.writeObject(object);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void serializeToFile(Serializable object, String fileName) throws IOException {
        OutputStream outputStream = FileUtils.getOutputStream(fileName);
        SerializationUtils.serialize(object, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T deserialize(InputStream inputStream) throws Throwable {
        ObjectInputStream in = null;
        try {
            Object obj;
            in = new ObjectInputStream(inputStream);
            Object object = obj = in.readObject();
            return (T)object;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static <T> T deserializeFromFile(String fileName) throws Throwable {
        InputStream inputStream = FileUtils.getInputStream(fileName);
        return SerializationUtils.deserialize(inputStream);
    }

    public static <T> T deepCopy(Serializable object) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            SerializationUtils.serialize(object, outputStream);
            return SerializationUtils.deserialize(new ByteArrayInputStream(outputStream.toByteArray()));
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed in performing a deep copy", e);
        }
    }
}

