/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.utils;

import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContents(String fileName) throws FileNotFoundException, IOException {
        Monitor mon = MonitorFactory.start("com.jamonapi.utils.FileUtils-getFileContents()");
        int EOF = -1;
        StringBuffer fileContents = new StringBuffer();
        BufferedReader inputStream = null;
        try {
            inputStream = new BufferedReader(new FileReader(fileName));
            int inputChar = inputStream.read();
            while (inputChar != -1) {
                fileContents.append((char)inputChar);
                inputChar = inputStream.read();
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            mon.stop();
        }
        return fileContents.toString();
    }

    public static String makeValidFileName(String fileName) {
        return fileName.replaceAll("[^a-zA-Z0-9_\\-\\.]", "-");
    }

    public static boolean mkdirs(String directoryName) {
        return new File(directoryName).mkdirs();
    }

    public static boolean exists(String fileOrDirectoryName) {
        File fileOrDirectory = new File(fileOrDirectoryName);
        return fileOrDirectory.exists();
    }

    public static boolean delete(String fileOrDirectoryName) {
        File file = new File(fileOrDirectoryName);
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static File[] listFiles(String directory, final String endsWithString) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String fileName) {
                return fileName.endsWith(endsWithString);
            }
        };
        return new File(directory).listFiles(filter);
    }

    public static OutputStream getOutputStream(String fileName) throws IOException {
        OutputStream file = new FileOutputStream(fileName);
        file = new BufferedOutputStream(file);
        return file;
    }

    public static InputStream getInputStream(String fileName) throws IOException {
        InputStream file = new FileInputStream(fileName);
        file = new BufferedInputStream(file);
        return file;
    }
}

