/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.distributed;

import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorCompositeIterator;
import com.jamonapi.distributed.JamonDataPersister;
import com.jamonapi.utils.Misc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class MonitorCompositeCombiner {
    private JamonDataPersister persister;

    public MonitorCompositeCombiner(JamonDataPersister persister) {
        this.persister = persister;
    }

    public MonitorComposite get(String ... instanceKeys) {
        ArrayList<MonitorComposite> monitorCompositeList = new ArrayList<MonitorComposite>();
        for (int i = 0; i < instanceKeys.length; ++i) {
            MonitorComposite monitorComposite = this.persister.get(instanceKeys[i]);
            if (monitorComposite == null) continue;
            monitorCompositeList.add(monitorComposite);
        }
        return MonitorCompositeCombiner.combine(monitorCompositeList);
    }

    public static MonitorComposite combine(Collection<MonitorComposite> monitorCompositeList) {
        MonitorComposite mc;
        Date previousDate = null;
        Date finalDate = null;
        Iterator<MonitorComposite> iter = monitorCompositeList.iterator();
        ArrayList<MonitorComposite> monitorCompositeResultsList = new ArrayList<MonitorComposite>();
        ArrayList<String> instanceNameList = new ArrayList<String>();
        while (iter.hasNext()) {
            mc = iter.next();
            instanceNameList.add(mc.getInstanceName());
            monitorCompositeResultsList.add(mc);
            if (previousDate == null || mc.getDateCreated().after(previousDate)) {
                finalDate = mc.getDateCreated();
            }
            previousDate = mc.getDateCreated();
        }
        mc = new MonitorCompositeIterator(monitorCompositeResultsList).toMonitorComposite().setDateCreated(finalDate);
        return mc.setInstanceName(Misc.getAsString(instanceNameList));
    }

    public void remove(String ... instanceKey) {
        for (int i = 0; i < instanceKey.length; ++i) {
            this.persister.remove(instanceKey[i]);
        }
    }
}

