/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class JamonPropertiesLoader {
    private String fileName;
    private Properties jamonProps;
    private List<JamonListener> listenerList;

    public JamonPropertiesLoader() {
        this("jamonapi.properties");
    }

    JamonPropertiesLoader(String fileName) {
        this.fileName = fileName;
    }

    public Properties getJamonProperties() {
        if (this.jamonProps == null) {
            this.initialize();
        }
        return this.jamonProps;
    }

    void initialize() {
        Properties defaults = this.getDefaults();
        Properties userProvided = this.propertyLoader(this.fileName);
        this.replaceWithCommandLineProps(userProvided, defaults);
        this.jamonProps = new Properties(defaults);
        this.jamonProps.putAll((Map<?, ?>)userProvided);
    }

    public URL getPropertiesDirectory() {
        return this.getClass().getClassLoader().getResource(".");
    }

    public List<JamonListener> getListeners() {
        if (this.jamonProps == null) {
            this.initialize();
        }
        if (this.listenerList == null) {
            this.addListeners();
        }
        return this.listenerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Properties propertyLoader(String fileName) {
        Properties properties = new Properties();
        InputStream input = null;
        try {
            input = this.getClass().getClassLoader().getResourceAsStream(fileName);
            if (input != null) {
                properties.load(input);
            }
            this.close(input);
        }
        catch (Throwable t) {
            this.close(input);
            catch (Throwable throwable) {
                this.close(input);
                throw throwable;
            }
        }
        return properties;
    }

    void close(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void replaceWithCommandLineProps(Properties properties, Properties defaults) {
        for (Object key : defaults.keySet()) {
            String value = System.getProperty(key.toString());
            if (value == null) continue;
            properties.put(key, value);
        }
    }

    Properties getDefaults() {
        Properties defaults = new Properties();
        defaults.put("distributedDataRefreshRateInMinutes", "5");
        defaults.put("jamonDataPersister", "com.jamonapi.distributed.HazelcastFilePersister");
        defaults.put("jamonDataPersister.label", "");
        defaults.put("jamonDataPersister.label.prefix", "");
        defaults.put("jamonDataPersister.directory", "jamondata");
        defaults.put("jamonListener.type", "value");
        defaults.put("jamonListener.name", "FIFOBuffer");
        defaults.put("jamonListener.size", "50");
        return defaults;
    }

    private void addListeners() {
        this.listenerList = new ArrayList<JamonListener>();
        int size = Integer.valueOf(this.jamonProps.getProperty("jamonListener.size"));
        for (int i = 0; i <= size; ++i) {
            String keyPrefix = this.getKeyPrefix(i);
            String listener = this.jamonProps.getProperty(keyPrefix + "key");
            if (listener == null) continue;
            this.listenerList.add(new JamonListener(keyPrefix));
        }
    }

    private String getKeyPrefix(int i) {
        return "jamonListener[" + i + "].";
    }

    public class JamonListener {
        private String keyPrefix;

        private JamonListener(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        private String[] split(String keyInfo) {
            String[] key = keyInfo.split(",");
            key[0] = key[0].trim();
            key[1] = key[1].trim();
            return key;
        }

        public String getLabel() {
            return this.split(JamonPropertiesLoader.this.jamonProps.getProperty(this.keyPrefix + "key"))[0];
        }

        public String getUnits() {
            return this.split(JamonPropertiesLoader.this.jamonProps.getProperty(this.keyPrefix + "key"))[1];
        }

        public String getListenerType() {
            String defaultProp = JamonPropertiesLoader.this.jamonProps.getProperty("jamonListener.type");
            return JamonPropertiesLoader.this.jamonProps.getProperty(this.keyPrefix + "type", defaultProp).trim();
        }

        public String getListenerName() {
            String defaultProp = JamonPropertiesLoader.this.jamonProps.getProperty("jamonListener.name");
            return JamonPropertiesLoader.this.jamonProps.getProperty(this.keyPrefix + "name", defaultProp).trim();
        }
    }
}

