/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.misc.ALU;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;

public class OrExpression
extends Expression {
    public Expression exp1;
    public Expression exp2;

    public OrExpression(Expression exp1, Expression exp2, GrammarToken token) {
        super(token);
        this.exp1 = exp1;
        this.exp2 = exp2;
    }

    @Override
    public Object evaluate(Context ctx) {
        if (ALU.isTrue(this.exp1.evaluate(ctx), this.exp1).booleanValue()) {
            return Boolean.TRUE;
        }
        return ALU.isTrue(this.exp2.evaluate(ctx), this.exp2);
    }

    @Override
    public void infer(InferContext inferCtx) {
        this.exp1.infer(inferCtx);
        this.exp2.infer(inferCtx);
    }
}

