/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.out;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.util.HashMap;
import java.util.Map;
import org.openjena.riot.out.NodeFmtLib;
import org.openjena.riot.system.MapWithScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeToLabel
extends MapWithScope<Node, String, Node> {
    private static final NodeToLabel _internal = NodeToLabel.createBNodeByLabel();

    public static NodeToLabel createScopeByDocument() {
        return new NodeToLabel(new SingleScopePolicy(), new AllocatorBNode());
    }

    public static NodeToLabel createScopeByGraph() {
        return new NodeToLabel(new GraphScopePolicy(), new AllocatorBNode());
    }

    public static NodeToLabel createBNodeByLabel() {
        return new NodeToLabel(new SingleScopePolicy(), new AllocatorInternal());
    }

    public static NodeToLabel createBNodeByLabelRaw() {
        return new NodeToLabel(new SingleScopePolicy(), new AllocatorInternalRaw());
    }

    public static NodeToLabel createBNodeByIRI() {
        return new NodeToLabel(new SingleScopePolicy(), new AllocatorBNodeAsIRI());
    }

    public static NodeToLabel labelByInternal() {
        return _internal;
    }

    private NodeToLabel(MapWithScope.ScopePolicy<Node, String, Node> scopePolicy, MapWithScope.Allocator<Node, String> allocator) {
        super(scopePolicy, allocator);
    }

    private static class AllocatorBNodeAsIRI
    extends AllocatorBase {
        private AllocatorBNodeAsIRI() {
        }

        protected String labelForBlank(Node node) {
            String str2 = node.getBlankNodeLabel();
            return "<_:" + str2 + ">";
        }
    }

    private static class AllocatorBNode
    extends AllocatorBase {
        private int X = 0;

        AllocatorBNode() {
        }

        protected String labelForBlank(Node node) {
            return "_:b" + Integer.toString(this.X++);
        }
    }

    private static class AllocatorInternal
    extends AllocatorBase {
        private AllocatorInternal() {
        }
    }

    private static class AllocatorInternalRaw
    extends AllocatorBase {
        private AllocatorInternalRaw() {
        }

        protected String labelForBlank(Node node) {
            return "_:" + node.getBlankNodeLabel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AllocatorBase
    implements MapWithScope.Allocator<Node, String> {
        private long counter = 0L;

        private AllocatorBase() {
        }

        @Override
        public final String create(Node node) {
            if (node.isURI()) {
                return this.labelForURI(node);
            }
            if (node.isLiteral()) {
                return this.labelForLiteral(node);
            }
            if (node.isBlank()) {
                return this.labelForBlank(node);
            }
            if (node.isVariable()) {
                return this.labelForVar(node);
            }
            return Long.toString(this.counter++);
        }

        protected String labelForURI(Node node) {
            return "<" + node.getURI() + ">";
        }

        protected String labelForBlank(Node node) {
            return "_:" + NodeFmtLib.safeBNodeLabel(node.getBlankNodeLabel());
        }

        protected String labelForLiteral(Node node) {
            return FmtUtils.stringForLiteral((Node_Literal)node, null);
        }

        protected String labelForVar(Node node) {
            return "?" + node.getName();
        }

        @Override
        public void reset() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GraphScopePolicy
    implements MapWithScope.ScopePolicy<Node, String, Node> {
        private Map<Node, String> dftMap = new HashMap<Node, String>();
        private Map<Node, Map<Node, String>> map = new HashMap<Node, Map<Node, String>>();

        private GraphScopePolicy() {
        }

        @Override
        public Map<Node, String> getScope(Node scope) {
            if (scope == null) {
                return this.dftMap;
            }
            Map<Node, String> x = this.map.get(scope);
            if (x == null) {
                x = new HashMap<Node, String>();
                this.map.put(scope, x);
            }
            return x;
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleScopePolicy
    implements MapWithScope.ScopePolicy<Node, String, Node> {
        private Map<Node, String> map = new HashMap<Node, String>();

        private SingleScopePolicy() {
        }

        @Override
        public Map<Node, String> getScope(Node scope) {
            return this.map;
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }
}

