/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.sparql.modify.UpdateEngineFactory;
import com.hp.hpl.jena.sparql.modify.UpdateEngineMain;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateEngineRegistry {
    List<UpdateEngineFactory> factories = new ArrayList<UpdateEngineFactory>();
    static UpdateEngineRegistry registry;

    public static UpdateEngineRegistry get() {
        if (registry == null) {
            UpdateEngineRegistry.init();
        }
        return registry;
    }

    private UpdateEngineRegistry() {
    }

    private static synchronized void init() {
        registry = new UpdateEngineRegistry();
        registry.add(UpdateEngineMain.getFactory());
    }

    public static UpdateEngineFactory findFactory(UpdateRequest request, GraphStore graphStore, Context context) {
        return UpdateEngineRegistry.get().find(request, graphStore, context);
    }

    public UpdateEngineFactory find(UpdateRequest request, GraphStore graphStore, Context context) {
        for (UpdateEngineFactory f : this.factories) {
            if (!f.accept(request, graphStore, context)) continue;
            return f;
        }
        return null;
    }

    public static void addFactory(UpdateEngineFactory f) {
        UpdateEngineRegistry.get().add(f);
    }

    public void add(UpdateEngineFactory f) {
        this.factories.add(0, f);
    }

    public static void removeFactory(UpdateEngineFactory f) {
        UpdateEngineRegistry.get().remove(f);
    }

    public void remove(UpdateEngineFactory f) {
        this.factories.remove(f);
    }

    public List<UpdateEngineFactory> factories() {
        return this.factories;
    }

    public static boolean containsFactory(UpdateEngineFactory f) {
        return UpdateEngineRegistry.get().contains(f);
    }

    public boolean contains(UpdateEngineFactory f) {
        return this.factories.contains(f);
    }

    static {
        UpdateEngineRegistry.init();
        registry = null;
    }
}

