/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.syntax.ElementBind;
import com.hp.hpl.jena.sparql.syntax.ElementSubQuery;
import com.hp.hpl.jena.sparql.syntax.PatternVars;
import com.hp.hpl.jena.sparql.syntax.PatternVarsVisitor;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxVarScope {
    public static void check(Query query2) {
        if (query2.getQueryPattern() == null) {
            return;
        }
        LinkedHashSet<Var> queryVars = new LinkedHashSet<Var>();
        PatternVarsVisitorChecker visitor = new PatternVarsVisitorChecker(queryVars);
        PatternVars.vars(query2.getQueryPattern(), visitor);
        queryVars.addAll(query2.getGroupBy().getVars());
        SyntaxVarScope.check(query2, queryVars);
    }

    private static void check(Query query2, Collection<Var> vars) {
        SyntaxVarScope.checkExprListAssignment(vars, query2.getProject());
        if (!Syntax.syntaxARQ.equals(query2.getSyntax()) && query2.isQueryResultStar() && query2.hasGroupBy()) {
            throw new QueryParseException("SELECT * not legal with GROUP BY", -1, -1);
        }
        SyntaxVarScope.checkExprVarUse(query2);
    }

    private static void checkExprListAssignment(Collection<Var> vars, VarExprList exprList) {
        LinkedHashSet<Var> vars2 = new LinkedHashSet<Var>(vars);
        for (Var v : exprList.getVars()) {
            Expr e2 = exprList.getExpr(v);
            SyntaxVarScope.checkAssignment(vars2, e2, v);
            vars2.add(v);
        }
    }

    private static void checkExprVarUse(Query query2) {
        if (query2.hasGroupBy()) {
            VarExprList groupKey = query2.getGroupBy();
            List<Var> groupVars = groupKey.getVars();
            VarExprList exprList = query2.getProject();
            for (Var v : exprList.getVars()) {
                Expr e2 = exprList.getExpr(v);
                if (e2 == null) {
                    if (groupVars.contains((Object)v)) continue;
                    throw new QueryParseException("Non-group key variable in SELECT: " + (Object)((Object)v), -1, -1);
                }
                Set<Var> eVars = e2.getVarsMentioned();
                for (Var v2 : eVars) {
                    if (groupVars.contains((Object)v2)) continue;
                    throw new QueryParseException("Non-group key variable in SELECT: " + (Object)((Object)v2) + " in expression " + e2, -1, -1);
                }
            }
        }
    }

    private static void checkAssignment(Collection<Var> scope, Expr expr, Var var) {
        if (expr == null) {
            return;
        }
        if (scope.contains((Object)var)) {
            throw new QueryParseException("Variable used when already in-scope: " + (Object)((Object)var) + " in " + SyntaxVarScope.fmtAssignment(expr, var), -1, -1);
        }
    }

    private static String fmtExprList(VarExprList exprList) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Var v : exprList.getVars()) {
            Expr e2 = exprList.getExpr(v);
            if (!first) {
                sb.append(" ");
            }
            first = false;
            sb.append("(").append(e2).append(" AS ").append((Object)v).append(")");
        }
        return sb.toString();
    }

    private static String fmtAssignment(Expr expr, Var var) {
        return "(" + expr + " AS " + (Object)((Object)var) + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PatternVarsVisitorChecker
    extends PatternVarsVisitor {
        public PatternVarsVisitorChecker(Set<Var> s) {
            super(s);
        }

        @Override
        public void visit(ElementBind el) {
            Var var = el.getVar();
            if (this.acc.contains((Object)var)) {
                throw new QueryParseException("Variable used when already in-scope: " + (Object)((Object)var) + " in " + el, -1, -1);
            }
            SyntaxVarScope.checkAssignment(this.acc, el.getExpr(), var);
        }

        @Override
        public void visit(ElementSubQuery el) {
            SyntaxVarScope.check(el.getQuery(), this.acc);
            super.visit(el);
        }
    }
}

