/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathBlock
implements Iterable<TriplePath> {
    private List<TriplePath> triplePaths = new ArrayList<TriplePath>();

    public PathBlock() {
    }

    public PathBlock(PathBlock other) {
        this.triplePaths.addAll(other.triplePaths);
    }

    public void add(TriplePath tp) {
        this.triplePaths.add(tp);
    }

    public void addAll(PathBlock other) {
        this.triplePaths.addAll(other.triplePaths);
    }

    public void add(int i, TriplePath tp) {
        this.triplePaths.add(i, tp);
    }

    public TriplePath get(int i) {
        return this.triplePaths.get(i);
    }

    @Override
    public ListIterator<TriplePath> iterator() {
        return this.triplePaths.listIterator();
    }

    public int size() {
        return this.triplePaths.size();
    }

    public boolean isEmpty() {
        return this.triplePaths.isEmpty();
    }

    public List<TriplePath> getList() {
        return this.triplePaths;
    }

    public int hashCode() {
        return ((Object)this.triplePaths).hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PathBlock)) {
            return false;
        }
        PathBlock bp = (PathBlock)other;
        return ((Object)this.triplePaths).equals(bp.triplePaths);
    }

    public boolean equiv(PathBlock other, NodeIsomorphismMap isoMap) {
        if (this.triplePaths.size() != other.triplePaths.size()) {
            return false;
        }
        for (int i = 0; i < this.triplePaths.size(); ++i) {
            TriplePath tp2;
            TriplePath tp1 = this.get(i);
            if (Utils.triplePathIso(tp1, tp2 = other.get(i), isoMap)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.triplePaths.toString();
    }
}

