/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.maven;

import com.heroku.sdk.maven.HerokuWarMojo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class RunWarMojo
extends HerokuWarMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.prepareWarFile();
            String javaCommand = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            String javaOpts = (String)this.configVars.get("JAVA_OPTS");
            String webappRunnerOpts = (String)this.configVars.get("WEBAPP_RUNNER_OPTS");
            ArrayList<String> fullCommand = new ArrayList<String>();
            fullCommand.add(javaCommand);
            if (null != javaOpts) {
                fullCommand.add(javaOpts);
            }
            fullCommand.add("-jar");
            fullCommand.add("target" + File.separator + "dependency" + File.separator + "webapp-runner.jar");
            if (null != webappRunnerOpts) {
                fullCommand.add(webappRunnerOpts);
            }
            fullCommand.add(this.warFile.getAbsolutePath());
            ProcessBuilder pb = new ProcessBuilder(new String[0]).command(fullCommand.toArray(new String[fullCommand.size()]));
            String fullCommandLine = javaCommand;
            for (String s : fullCommand) {
                fullCommandLine = fullCommandLine + " " + s;
            }
            this.getLog().debug((CharSequence)("Executing: " + fullCommandLine));
            Process p = pb.start();
            StreamGobbler inputGobbler = new StreamGobbler(p.getInputStream());
            inputGobbler.start();
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream());
            errorGobbler.start();
            p.waitFor();
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to deploy application", (Throwable)e);
        }
    }

    private class StreamGobbler
    extends Thread {
        InputStream is;

        StreamGobbler(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                String line;
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    RunWarMojo.this.getLog().info((CharSequence)line);
                }
            }
            catch (IOException e) {
                RunWarMojo.this.getLog().error((CharSequence)e.getMessage());
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }
}

