/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy;

import com.heroku.sdk.deploy.ConfigVars;
import com.heroku.sdk.deploy.Toolbelt;
import com.heroku.sdk.deploy.endpoints.Slug;
import com.heroku.sdk.deploy.utils.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import sun.misc.BASE64Encoder;

public abstract class Deployer {
    protected String buildPackDesc;
    protected String name;
    protected File rootDir;
    protected File targetDir;
    protected String encodedApiKey = null;
    protected Logger logger;

    public void logInfo(String message) {
        this.logger.logInfo(message);
    }

    public void logDebug(String message) {
        this.logger.logDebug(message);
    }

    public void logWarn(String message) {
        this.logger.logWarn(message);
    }

    public Deployer(String buildPackDesc, String name, File rootDir, File targetDir, Logger logger) {
        this.logger = logger;
        this.buildPackDesc = buildPackDesc;
        this.name = this.getHerokuProperties().getProperty("heroku.appName", name);
        try {
            if (this.name == null) {
                this.name = Toolbelt.getAppName(rootDir);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find app name: " + e.getMessage(), e);
        }
        this.rootDir = rootDir;
        this.targetDir = targetDir;
        try {
            FileUtils.forceDelete((File)this.getAppDir());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getHerokuDir().mkdir();
        this.getAppDir().mkdir();
    }

    public String getName() {
        return this.name;
    }

    public String getBuildPackDesc() {
        return this.buildPackDesc;
    }

    protected void deploy(Map<String, String> configVars, String jdkVersion, URL jdkUrl, String stack, Map<String, String> processTypes, String slugFilename) throws Exception {
        this.mergeConfigVars(configVars);
        this.vendorJdk(jdkVersion, jdkUrl, stack);
        this.createAndReleaseSlug(stack, processTypes, slugFilename);
    }

    public void prepare(List<File> includedFiles, Map<String, String> processTypes) throws IOException {
        this.logInfo("-----> Packaging application...");
        this.logInfo("       - app: " + this.name);
        try {
            for (File file : includedFiles) {
                this.logInfo("       - including: " + this.relativize(file));
                this.copy(file, new File(this.getAppDir(), this.relativize(file)));
            }
            try {
                FileUtils.forceDelete((File)new File(this.getAppDir(), this.relativize(this.getHerokuDir())));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.addExtras(processTypes);
        }
        catch (IOException ioe) {
            throw new IOException("There was an error packaging the application for deployment.", ioe);
        }
    }

    protected void addExtras(Map<String, String> processTypes) throws IOException {
    }

    protected void copy(File file, File copyTarget) throws IOException {
        if (file.isDirectory()) {
            Files.walkFileTree(file.toPath(), new CopyFileVisitor(copyTarget.toPath()));
        } else {
            Files.createDirectories(copyTarget.getParentFile().toPath(), new FileAttribute[0]);
            Files.copy(file.toPath(), copyTarget.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
        }
    }

    protected void mergeConfigVars(Map<String, String> configVars) throws Exception {
        new ConfigVars(this, this.getEncodedApiKey()).merge(configVars);
    }

    protected void createAndReleaseSlug(String stack, Map<String, String> processTypes, String slugFilename) throws IOException, ArchiveException, InterruptedException {
        this.deploySlug(stack, processTypes, this.buildSlugFile(slugFilename));
        this.logInfo("-----> Done");
    }

    protected abstract File buildSlugFile(String var1) throws InterruptedException, ArchiveException, IOException;

    protected abstract void deploySlug(String var1, Map<String, String> var2, File var3) throws IOException, ArchiveException, InterruptedException;

    protected void uploadSlug(Slug slug, File slugFile, Set processTypes) throws IOException, ArchiveException, InterruptedException {
        this.logInfo("-----> Uploading slug...");
        slug.upload(slugFile, this.logger);
        this.logInfo("       - stack: " + slug.getStackName());
        this.logInfo("       - process types: " + processTypes);
    }

    protected void releaseSlug(Slug slug) throws IOException {
        this.logInfo("-----> Releasing...");
        Map releaseResponse = slug.release();
        this.logDebug("Heroku Release response: " + releaseResponse);
        this.logInfo("       - version: " + releaseResponse.get("version"));
    }

    protected String getJdkVersion() {
        String defaultJdkVersion = "1.8";
        File sysPropsFile = new File(this.rootDir, "system.properties");
        if (sysPropsFile.exists()) {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(sysPropsFile));
                return props.getProperty("java.runtime.version", defaultJdkVersion);
            }
            catch (IOException e) {
                this.logDebug(e.getMessage());
            }
        }
        return defaultJdkVersion;
    }

    protected Properties getHerokuProperties() {
        Properties props = new Properties();
        File sysPropsFile = new File(this.rootDir, "heroku.properties");
        if (sysPropsFile.exists()) {
            try {
                props.load(new FileInputStream(sysPropsFile));
            }
            catch (IOException e) {
                this.logDebug(e.getMessage());
            }
        }
        return props;
    }

    protected Map<String, String> getProcfile() {
        HashMap<String, String> procTypes = new HashMap<String, String>();
        File procfile = new File(this.rootDir, "Procfile");
        if (procfile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(procfile));
                String line = reader.readLine();
                while (line != null) {
                    if (line.contains(":")) {
                        Integer colon = line.indexOf(":");
                        String key = line.substring(0, colon);
                        String value = line.substring(colon + 1);
                        procTypes.put(key.trim(), value.trim());
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                this.logDebug(e.getMessage());
            }
        }
        return procTypes;
    }

    protected abstract void vendorJdk(String var1, URL var2, String var3) throws IOException, InterruptedException, ArchiveException;

    protected String relativize(File path) {
        if (path.isAbsolute() && !path.getPath().startsWith(this.rootDir.getPath())) {
            return path.getName();
        }
        return this.rootDir.toURI().relativize(path.toURI()).getPath();
    }

    protected String getEncodedApiKey() throws IOException {
        if (this.encodedApiKey == null) {
            String apiKey = System.getenv("HEROKU_API_KEY");
            if (null == apiKey || apiKey.isEmpty()) {
                try {
                    apiKey = Toolbelt.getApiToken();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (apiKey == null || apiKey.isEmpty()) {
                throw new RuntimeException("Could not get API key! Please install the toolbelt and login with `heroku login` or set the HEROKU_API_KEY environment variable.");
            }
            this.encodedApiKey = new BASE64Encoder().encode((":" + apiKey).getBytes());
        }
        return this.encodedApiKey;
    }

    protected File getAppDir() {
        return new File(this.getHerokuDir(), "app");
    }

    protected File getHerokuDir() {
        return new File(this.targetDir, "heroku");
    }

    protected File getRootDir() {
        return this.rootDir;
    }

    protected File getTargetDir() {
        return this.targetDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyResourceFile(String srcFilename, File targetFile) throws IOException {
        BufferedWriter out = null;
        try {
            String line;
            InputStream is = this.getClass().getResourceAsStream("/" + srcFilename);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            FileWriter fw = new FileWriter(targetFile);
            out = new BufferedWriter(fw);
            while ((line = br.readLine()) != null) {
                out.write(line);
                out.write("\n");
            }
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }

    protected String parseCommit() throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setWorkTree(this.getRootDir())).readEnvironment()).findGitDir()).build();
        ObjectId head = repository.resolve("HEAD");
        return head == null ? null : head.name();
    }

    public static class CopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path targetPath;
        private Path sourcePath = null;

        public CopyFileVisitor(Path targetPath) {
            this.targetPath = targetPath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (dir.equals(this.targetPath)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (this.sourcePath == null) {
                this.sourcePath = dir;
            }
            Files.createDirectories(this.targetPath.resolve(this.sourcePath.relativize(dir)), new FileAttribute[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.targetPath.resolve(this.sourcePath.relativize(file)), StandardCopyOption.COPY_ATTRIBUTES);
            return FileVisitResult.CONTINUE;
        }
    }
}

