/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy;

import com.heroku.sdk.deploy.WarApp;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class DeployWar
extends WarApp {
    public static final String DEFAULT_WEBAPP_RUNNER_VERSION = "8.0.23.0";
    private static final String WEBAPP_RUNNER_URL_FORMAT = "http://central.maven.org/maven2/com/github/jsimone/webapp-runner/%s/webapp-runner-%s.jar";

    public DeployWar(String name, File warFile, URL webappRunnerUrl) throws IOException {
        super(name);
        this.warFile = warFile;
        this.webappRunnerJar = new File(this.getAppDir(), "webapp-runner.jar");
        FileUtils.copyURLToFile((URL)webappRunnerUrl, (File)this.webappRunnerJar);
    }

    @Override
    protected Map<String, String> defaultProcTypes() {
        HashMap<String, String> processTypes = new HashMap<String, String>();
        processTypes.put("web", "java $JAVA_OPTS -jar webapp-runner.jar ${WEBAPP_RUNNER_OPTS:-\"--expand-war\"} --port $PORT ./" + this.relativize(this.warFile));
        return processTypes;
    }

    private static List<File> includesToList(String includes) {
        List<String> includeStrings = Arrays.asList(includes.split(File.pathSeparator));
        ArrayList<File> includeFiles = new ArrayList<File>(includeStrings.size());
        for (String includeString : includeStrings) {
            if (includeString.isEmpty()) continue;
            includeFiles.add(new File(includeString));
        }
        return includeFiles;
    }

    @Override
    public void logInfo(String message) {
        System.out.println(message);
    }

    public static void main(String[] args) throws Exception {
        String warFile = System.getProperty("heroku.warFile", null);
        String appName = System.getProperty("heroku.appName", null);
        String jdkVersion = System.getProperty("heroku.jdkVersion", null);
        String jdkUrl = System.getProperty("heroku.jdkUrl", null);
        String stack = System.getProperty("heroku.stack", "cedar-14");
        List<File> includes = DeployWar.includesToList(System.getProperty("heroku.includes", ""));
        String slugFileName = System.getProperty("heroku.slugFileName", "slug.tgz");
        String webappRunnerVersion = System.getProperty("heroku.webappRunnerVersion", DEFAULT_WEBAPP_RUNNER_VERSION);
        String webappRunnerUrl = System.getProperty("heroku.webappRunnerUrl", String.format(WEBAPP_RUNNER_URL_FORMAT, webappRunnerVersion, webappRunnerVersion));
        if (warFile == null) {
            throw new IllegalArgumentException("Path to WAR file must be provided with heroku.warFile system property!");
        }
        if (appName == null) {
            throw new IllegalArgumentException("Heroku app name must be provided with heroku.appName system property!");
        }
        new DeployWar(appName, new File(warFile), new URL(webappRunnerUrl)).deploy(includes, new HashMap<String, String>(), jdkUrl == null ? jdkVersion : jdkUrl, stack, slugFileName);
    }
}

