/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.filter.AbstractFilter;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.XMLHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Element;

@NotThreadSafe
public class FilterElementWithNamespaceAndLocalName
extends AbstractFilter<Element> {
    private final String m_sNamespaceURI;
    private final String m_sLocalName;

    public FilterElementWithNamespaceAndLocalName(@Nullable String string, @Nonnull @Nonempty String string2) {
        this.m_sNamespaceURI = string;
        this.m_sLocalName = ValueEnforcer.notEmpty(string2, "LocalName");
    }

    @Nullable
    public String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Nonnull
    @Nonempty
    public String getLocalName() {
        return this.m_sLocalName;
    }

    @Override
    public boolean matchesThisFilter(@Nullable Element element) {
        return element != null && XMLHelper.hasNamespaceURI(element, this.m_sNamespaceURI) && element.getLocalName().equals(this.m_sLocalName);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FilterElementWithNamespaceAndLocalName filterElementWithNamespaceAndLocalName = (FilterElementWithNamespaceAndLocalName)object;
        return EqualsHelper.equals(this.m_sNamespaceURI, filterElementWithNamespaceAndLocalName.m_sNamespaceURI) && this.m_sLocalName.equals(filterElementWithNamespaceAndLocalName.m_sLocalName);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_sNamespaceURI).append(this.m_sLocalName).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("namespaceURI", this.m_sNamespaceURI).append("localName", this.m_sLocalName).toString();
    }
}

