/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.state;

import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.state.ISuccessIndicator;
import javax.annotation.Nonnull;

public enum ESuccess implements ISuccessIndicator
{
    SUCCESS,
    FAILURE;


    @Override
    public boolean isSuccess() {
        return this == SUCCESS;
    }

    @Override
    public boolean isFailure() {
        return this == FAILURE;
    }

    @Nonnull
    public ESuccess or(@Nonnull ISuccessIndicator iSuccessIndicator) {
        return ESuccess.valueOf(this.isSuccess() || iSuccessIndicator.isSuccess());
    }

    @Nonnull
    public ESuccess and(@Nonnull ISuccessIndicator iSuccessIndicator) {
        return ESuccess.valueOf(this.isSuccess() && iSuccessIndicator.isSuccess());
    }

    @Nonnull
    public static ESuccess valueOf(boolean bl) {
        return bl ? SUCCESS : FAILURE;
    }

    @Nonnull
    public static ESuccess valueOf(@Nonnull ISuccessIndicator iSuccessIndicator) {
        return ESuccess.valueOf(iSuccessIndicator.isSuccess());
    }

    @Nonnull
    public static ESuccess valueOfChange(@Nonnull IChangeIndicator iChangeIndicator) {
        return ESuccess.valueOf(iChangeIndicator.isChanged());
    }
}

