/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MimeTypeInfo {
    private final Set<MimeTypeWithSource> m_aMimeTypes;
    private final String m_sComment;
    private final Set<String> m_aParentTypes;
    private final Set<String> m_aGlobs;
    private final Set<ExtensionWithSource> m_aExtensions;
    private final String m_sSource;

    public MimeTypeInfo(@Nonnull @Nonempty Set<MimeTypeWithSource> set, @Nullable String string, @Nonnull Set<String> set2, @Nonnull Set<String> set3, @Nonnull Set<ExtensionWithSource> set4, @Nullable String string2) {
        ValueEnforcer.notEmptyNoNullValue(set, "MimeTypes");
        ValueEnforcer.notNull(set2, "ParentTypes");
        ValueEnforcer.notNull(set3, "Globs");
        ValueEnforcer.notNull(set4, "Extensions");
        this.m_aMimeTypes = CollectionHelper.newOrderedSet(set);
        this.m_sComment = string;
        this.m_aParentTypes = CollectionHelper.newOrderedSet(set2);
        this.m_aGlobs = CollectionHelper.newOrderedSet(set3);
        this.m_aExtensions = CollectionHelper.newOrderedSet(set4);
        this.m_sSource = string2;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public Set<MimeTypeWithSource> getAllMimeTypesWithSource() {
        return CollectionHelper.newOrderedSet(this.m_aMimeTypes);
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public Set<IMimeType> getAllMimeTypes() {
        LinkedHashSet<IMimeType> linkedHashSet = new LinkedHashSet<IMimeType>();
        for (MimeTypeWithSource mimeTypeWithSource : this.m_aMimeTypes) {
            linkedHashSet.add(mimeTypeWithSource.getMimeType());
        }
        return linkedHashSet;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public Set<String> getAllMimeTypeStrings() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (MimeTypeWithSource mimeTypeWithSource : this.m_aMimeTypes) {
            linkedHashSet.add(mimeTypeWithSource.getMimeTypeAsString());
        }
        return linkedHashSet;
    }

    public boolean containsMimeType(@Nullable IMimeType iMimeType) {
        if (iMimeType != null) {
            for (MimeTypeWithSource mimeTypeWithSource : this.m_aMimeTypes) {
                if (!mimeTypeWithSource.getMimeType().equals(iMimeType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsMimeType(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            for (MimeTypeWithSource mimeTypeWithSource : this.m_aMimeTypes) {
                if (!mimeTypeWithSource.getMimeTypeAsString().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public MimeTypeWithSource getPrimaryMimeTypeWithSource() {
        return CollectionHelper.getFirstElement(this.m_aMimeTypes);
    }

    @Nonnull
    public IMimeType getPrimaryMimeType() {
        return this.getPrimaryMimeTypeWithSource().getMimeType();
    }

    @Nonnull
    public String getPrimaryMimeTypeString() {
        return this.getPrimaryMimeTypeWithSource().getMimeTypeAsString();
    }

    @Nullable
    public String getComment() {
        return this.m_sComment;
    }

    public boolean hasComment() {
        return StringHelper.hasText(this.m_sComment);
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllParentTypes() {
        return CollectionHelper.newOrderedSet(this.m_aParentTypes);
    }

    public boolean hasAnyParentType() {
        return !this.m_aParentTypes.isEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllGlobs() {
        return CollectionHelper.newOrderedSet(this.m_aGlobs);
    }

    @Nullable
    public String getPrimaryGlob() {
        return CollectionHelper.getFirstElement(this.m_aGlobs);
    }

    public boolean hasAnyGlob() {
        return !this.m_aGlobs.isEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<ExtensionWithSource> getAllExtensionsWithSource() {
        return CollectionHelper.newOrderedSet(this.m_aExtensions);
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllExtensions() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (ExtensionWithSource extensionWithSource : this.m_aExtensions) {
            linkedHashSet.add(extensionWithSource.getExtension());
        }
        return linkedHashSet;
    }

    @Nullable
    public ExtensionWithSource getPrimaryExtensionWithSource() {
        return CollectionHelper.getFirstElement(this.m_aExtensions);
    }

    @Nullable
    public String getPrimaryExtension() {
        ExtensionWithSource extensionWithSource = this.getPrimaryExtensionWithSource();
        return extensionWithSource == null ? null : extensionWithSource.getExtension();
    }

    public boolean hasAnyExtension() {
        return !this.m_aExtensions.isEmpty();
    }

    public boolean containsExtension(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            for (ExtensionWithSource extensionWithSource : this.m_aExtensions) {
                if (!extensionWithSource.matches(string)) continue;
                return true;
            }
        }
        return false;
    }

    void addExtension(@Nonnull ExtensionWithSource extensionWithSource) {
        ValueEnforcer.notNull(extensionWithSource, "Ext");
        this.m_aExtensions.add(extensionWithSource);
    }

    void addMimeType(@Nonnull MimeTypeWithSource mimeTypeWithSource) {
        ValueEnforcer.notNull(mimeTypeWithSource, "MimeType");
        this.m_aMimeTypes.add(mimeTypeWithSource);
    }

    @Nullable
    public String getSource() {
        return this.m_sSource;
    }

    public boolean hasSource() {
        return StringHelper.hasText(this.m_sSource);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MimeTypeInfo mimeTypeInfo = (MimeTypeInfo)object;
        return this.m_aMimeTypes.equals(mimeTypeInfo.m_aMimeTypes);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aMimeTypes)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("mimeTypes", this.m_aMimeTypes).appendIfNotNull("comment", this.m_sComment).appendIfNotEmpty("parentTypes", this.m_aParentTypes).appendIfNotEmpty("globs", this.m_aGlobs).appendIfNotEmpty("extensions", this.m_aExtensions).appendIfNotNull("source", this.m_sSource).toString();
    }

    @Immutable
    public static final class ExtensionWithSource {
        private final String m_sExt;
        private final String m_sSource;

        public ExtensionWithSource(@Nonnull String string) {
            this(string, null);
        }

        public ExtensionWithSource(@Nonnull String string, @Nullable String string2) {
            this.m_sExt = ValueEnforcer.notNull(string, "Extension");
            this.m_sSource = string2;
        }

        @Nonnull
        public String getExtension() {
            return this.m_sExt;
        }

        @Nullable
        public String getSource() {
            return this.m_sSource;
        }

        public boolean matches(@Nonnull @Nonempty String string) {
            if (this.m_sExt.contains(string)) {
                return true;
            }
            return this.m_sExt.contains(string.toLowerCase(Locale.US));
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            ExtensionWithSource extensionWithSource = (ExtensionWithSource)object;
            return this.m_sExt.equals(extensionWithSource.m_sExt) && EqualsHelper.equals(this.m_sSource, extensionWithSource.m_sSource);
        }

        public int hashCode() {
            return new HashCodeGenerator(this).append(this.m_sExt).append(this.m_sSource).getHashCode();
        }

        public String toString() {
            return new ToStringGenerator(this).append("extension", this.m_sExt).appendIfNotNull("source", this.m_sSource).toString();
        }
    }

    @Immutable
    public static final class MimeTypeWithSource {
        private final IMimeType m_aMimeType;
        private final String m_sSource;

        public MimeTypeWithSource(@Nonnull String string) {
            this(MimeTypeParser.parseMimeType(string), null);
        }

        public MimeTypeWithSource(@Nonnull IMimeType iMimeType) {
            this(iMimeType, null);
        }

        public MimeTypeWithSource(@Nonnull IMimeType iMimeType, @Nullable String string) {
            this.m_aMimeType = ValueEnforcer.notNull(iMimeType, "MimeType");
            this.m_sSource = string;
        }

        @Nonnull
        public IMimeType getMimeType() {
            return this.m_aMimeType;
        }

        @Nonnull
        @Nonempty
        public String getMimeTypeAsString() {
            return this.m_aMimeType.getAsString();
        }

        @Nullable
        public String getSource() {
            return this.m_sSource;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            MimeTypeWithSource mimeTypeWithSource = (MimeTypeWithSource)object;
            return this.m_aMimeType.equals(mimeTypeWithSource.m_aMimeType) && EqualsHelper.equals(this.m_sSource, mimeTypeWithSource.m_sSource);
        }

        public int hashCode() {
            return new HashCodeGenerator(this).append(this.m_aMimeType).append(this.m_sSource).getHashCode();
        }

        public String toString() {
            return new ToStringGenerator(this).append("mimeType", this.m_aMimeType).appendIfNotNull("source", this.m_sSource).toString();
        }
    }
}

