/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.stream;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.io.stream.WrappedInputStream;
import com.helger.commons.messagedigest.EMessageDigestAlgorithm;
import com.helger.commons.messagedigest.IMessageDigestGenerator;
import com.helger.commons.messagedigest.NonBlockingMessageDigestGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;

public class MessageDigestInputStream
extends WrappedInputStream {
    private final IMessageDigestGenerator m_aMDGen;

    public MessageDigestInputStream(@Nonnull InputStream inputStream, @Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm) {
        super(inputStream);
        this.m_aMDGen = new NonBlockingMessageDigestGenerator(eMessageDigestAlgorithm);
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            this.m_aMDGen.update((byte)n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.m_aMDGen.update(byArray, n, n3);
        }
        return n3;
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getAllDigestBytes() {
        return this.m_aMDGen.getAllDigestBytes();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("mdgen", this.m_aMDGen).toString();
    }
}

