/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.csv;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.csv.CSVIterator;
import com.helger.commons.csv.CSVLineReaderBufferedReader;
import com.helger.commons.csv.CSVLineReaderKeepCR;
import com.helger.commons.csv.CSVLineReaderNonBlockingBufferedReader;
import com.helger.commons.csv.CSVParser;
import com.helger.commons.csv.ICSVLineReader;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.io.stream.StreamHelper;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CSVReader
implements Closeable,
Iterable<List<String>> {
    private final Reader m_aReader;
    private final ICSVLineReader m_aLineReader;
    private final CSVParser m_aParser;
    private int m_nSkipLines = 0;
    private final boolean m_bKeepCR;
    private boolean m_bVerifyReader = true;
    private boolean m_bHasNext = true;
    private boolean m_bLinesSkiped = false;

    public CSVReader(@Nonnull Reader reader) {
        this(reader, new CSVParser(), false);
    }

    public CSVReader(@Nonnull Reader reader, boolean bl) {
        this(reader, new CSVParser(), bl);
    }

    public CSVReader(@Nonnull Reader reader, @Nonnull CSVParser cSVParser, boolean bl) {
        ValueEnforcer.notNull(reader, "Reader");
        ValueEnforcer.notNull(cSVParser, "Parser");
        Reader reader2 = StreamHelper.getBuffered(reader);
        if (bl) {
            this.m_aLineReader = new CSVLineReaderKeepCR(reader2);
        } else if (reader2 instanceof BufferedReader) {
            this.m_aLineReader = new CSVLineReaderBufferedReader((BufferedReader)reader2);
        } else {
            if (!(reader2 instanceof NonBlockingBufferedReader)) {
                reader2 = new NonBlockingBufferedReader(reader2);
            }
            this.m_aLineReader = new CSVLineReaderNonBlockingBufferedReader((NonBlockingBufferedReader)reader2);
        }
        this.m_aReader = reader2;
        this.m_aParser = cSVParser;
        this.m_bKeepCR = bl;
    }

    @Nonnull
    public CSVParser getParser() {
        return this.m_aParser;
    }

    public char getSeparatorChar() {
        return this.m_aParser.getSeparatorChar();
    }

    @Nonnull
    public CSVReader setSeparatorChar(char c) {
        this.m_aParser.setSeparatorChar(c);
        return this;
    }

    public char getQuoteChar() {
        return this.m_aParser.getQuoteChar();
    }

    @Nonnull
    public CSVReader setQuoteChar(char c) {
        this.m_aParser.setQuoteChar(c);
        return this;
    }

    public char getEscapeChar() {
        return this.m_aParser.getEscapeChar();
    }

    @Nonnull
    public CSVReader setEscapeChar(char c) {
        this.m_aParser.setEscapeChar(c);
        return this;
    }

    public boolean isStrictQuotes() {
        return this.m_aParser.isStrictQuotes();
    }

    @Nonnull
    public CSVReader setStrictQuotes(boolean bl) {
        this.m_aParser.setStrictQuotes(bl);
        return this;
    }

    public boolean isIgnoreLeadingWhiteSpace() {
        return this.m_aParser.isIgnoreLeadingWhiteSpace();
    }

    @Nonnull
    public CSVReader setIgnoreLeadingWhiteSpace(boolean bl) {
        this.m_aParser.setIgnoreLeadingWhiteSpace(bl);
        return this;
    }

    public boolean isIgnoreQuotations() {
        return this.m_aParser.isIgnoreQuotations();
    }

    @Nonnull
    public CSVReader setIgnoreQuotations(boolean bl) {
        this.m_aParser.setIgnoreQuotations(bl);
        return this;
    }

    @Nonnegative
    public int getSkipLines() {
        return this.m_nSkipLines;
    }

    @Nonnull
    public CSVReader setSkipLines(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "SkipLines");
        this.m_nSkipLines = n;
        return this;
    }

    public boolean isKeepCarriageReturns() {
        return this.m_bKeepCR;
    }

    public boolean isVerifyReader() {
        return this.m_bVerifyReader;
    }

    @Nonnull
    public CSVReader setVerifyReader(boolean bl) {
        this.m_bVerifyReader = bl;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<List<String>> readAll() throws IOException {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        while (this.m_bHasNext) {
            List<String> list = this.readNext();
            if (list == null) continue;
            arrayList.add(list);
        }
        return arrayList;
    }

    @Nullable
    public List<String> readNext() throws IOException {
        List<String> list = null;
        do {
            String string = this._getNextLine();
            if (!this.m_bHasNext) {
                return list;
            }
            List<String> list2 = this.m_aParser.parseLineMulti(string);
            if (list == null) {
                list = list2;
                continue;
            }
            list.addAll(list2);
        } while (this.m_aParser.isPending());
        return list;
    }

    @Nullable
    private String _getNextLine() throws IOException {
        if (this._isClosed()) {
            this.m_bHasNext = false;
            return null;
        }
        if (!this.m_bLinesSkiped) {
            for (int i = 0; i < this.m_nSkipLines; ++i) {
                this.m_aLineReader.readLine();
            }
            this.m_bLinesSkiped = true;
        }
        if (!this.m_bHasNext) {
            return null;
        }
        String string = this.m_aLineReader.readLine();
        if (string == null) {
            this.m_bHasNext = false;
        }
        return string;
    }

    private boolean _isClosed() {
        if (!this.m_bVerifyReader) {
            return false;
        }
        try {
            return !this.m_aReader.ready();
        }
        catch (IOException iOException) {
            return true;
        }
    }

    @Override
    public void close() throws IOException {
        this.m_aReader.close();
    }

    @Override
    @Nonnull
    public Iterator<List<String>> iterator() {
        try {
            return new CSVIterator(this);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error creating CSVIterator", iOException);
        }
    }
}

