/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.BackupCompletionCallback;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.TraceableOperation;
import com.hazelcast.spi.WaitSupport;
import com.hazelcast.spi.exception.CallTimeoutException;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.exception.RetryableIOException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.spi.impl.BasicOperationService;
import com.hazelcast.spi.impl.BasicTargetInvocation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.NormalResponse;
import com.hazelcast.spi.impl.RemoteCall;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ValidationUtil;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

abstract class BasicInvocation
implements Callback<Object>,
BackupCompletionCallback {
    private static final Object NULL_RESPONSE = new InternalResponse("Invocation::NULL_RESPONSE");
    private static final Object RETRY_RESPONSE = new InternalResponse("Invocation::RETRY_RESPONSE");
    private static final Object WAIT_RESPONSE = new InternalResponse("Invocation::WAIT_RESPONSE");
    private static final Object TIMEOUT_RESPONSE = new InternalResponse("Invocation::TIMEOUT_RESPONSE");
    private static final Object INTERRUPTED_RESPONSE = new InternalResponse("Invocation::INTERRUPTED_RESPONSE");
    private static final long MIN_TIMEOUT = 10000L;
    protected final long callTimeout;
    protected final NodeEngineImpl nodeEngine;
    protected final String serviceName;
    protected final Operation op;
    protected final int partitionId;
    protected final int replicaIndex;
    protected final int tryCount;
    protected final long tryPauseMillis;
    protected final ILogger logger;
    private final InvocationFuture invocationFuture;
    private volatile int invokeCount = 0;
    private volatile Address target;
    private boolean remote = false;
    private final String executorName;
    private final boolean resultDeserialized;
    private volatile int reinvocations = 0;
    private volatile int availableBackups;
    private volatile NormalResponse potentialResponse;
    private volatile int expectedBackupCount;

    private static long decrementTimeout(long timeout, long diff) {
        if (timeout != Long.MAX_VALUE) {
            timeout -= diff;
        }
        return timeout;
    }

    BasicInvocation(NodeEngineImpl nodeEngine, String serviceName, Operation op, int partitionId, int replicaIndex, int tryCount, long tryPauseMillis, long callTimeout, Callback<Object> callback, String executorName, boolean resultDeserialized) {
        this.logger = nodeEngine.getLogger(BasicInvocation.class);
        this.nodeEngine = nodeEngine;
        this.serviceName = serviceName;
        this.op = op;
        this.partitionId = partitionId;
        this.replicaIndex = replicaIndex;
        this.tryCount = tryCount;
        this.tryPauseMillis = tryPauseMillis;
        this.callTimeout = this.getCallTimeout(callTimeout);
        this.invocationFuture = new InvocationFuture(callback);
        this.executorName = executorName;
        this.resultDeserialized = resultDeserialized;
    }

    abstract ExceptionAction onException(Throwable var1);

    public String getServiceName() {
        return this.serviceName;
    }

    InternalPartition getPartition() {
        return this.nodeEngine.getPartitionService().getPartition(this.partitionId);
    }

    public int getReplicaIndex() {
        return this.replicaIndex;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    private ExecutorService getAsyncExecutor() {
        return this.nodeEngine.getExecutionService().getExecutor("hz:async");
    }

    private long getCallTimeout(long callTimeout) {
        long waitTimeoutMillis;
        if (callTimeout > 0L) {
            return callTimeout;
        }
        BasicOperationService operationService = (BasicOperationService)this.nodeEngine.operationService;
        long defaultCallTimeout = operationService.getDefaultCallTimeout();
        if (this.op instanceof WaitSupport && (waitTimeoutMillis = this.op.getWaitTimeout()) > 0L && waitTimeoutMillis < Long.MAX_VALUE) {
            long max = Math.max(waitTimeoutMillis, 10000L);
            return Math.min(max, defaultCallTimeout);
        }
        return defaultCallTimeout;
    }

    public final InvocationFuture invoke() {
        if (this.invokeCount > 0) {
            throw new IllegalStateException("An invocation can not be invoked more than once!");
        }
        if (this.op.getCallId() != 0L) {
            throw new IllegalStateException("An operation[" + this.op + "] can not be used for multiple invocations!");
        }
        try {
            BasicOperationService operationService;
            OperationAccessor.setCallTimeout(this.op, this.callTimeout);
            OperationAccessor.setCallerAddress(this.op, this.nodeEngine.getThisAddress());
            this.op.setNodeEngine(this.nodeEngine).setServiceName(this.serviceName).setPartitionId(this.partitionId).setReplicaIndex(this.replicaIndex).setExecutorName(this.executorName);
            if (this.op.getCallerUuid() == null) {
                this.op.setCallerUuid(this.nodeEngine.getLocalMember().getUuid());
            }
            if (!(operationService = (BasicOperationService)this.nodeEngine.operationService).isInvocationAllowedFromCurrentThread(this.op) && !OperationAccessor.isMigrationOperation(this.op)) {
                throw new IllegalThreadStateException(Thread.currentThread() + " cannot make remote call: " + this.op);
            }
            this.doInvoke();
        }
        catch (Exception e) {
            if (e instanceof RetryableException) {
                this.notify(e);
            }
            throw ExceptionUtil.rethrow(e);
        }
        return this.invocationFuture;
    }

    private void resetAndReInvoke() {
        ++this.reinvocations;
        this.invokeCount = 0;
        this.potentialResponse = null;
        this.expectedBackupCount = -1;
        this.doInvoke();
    }

    private static Throwable getError(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Throwable) {
            return (Throwable)obj;
        }
        if (!(obj instanceof NormalResponse)) {
            return null;
        }
        NormalResponse response = (NormalResponse)obj;
        if (!(response.getValue() instanceof Throwable)) {
            return null;
        }
        return (Throwable)response.getValue();
    }

    @Override
    public void notify(Object obj) {
        NormalResponse resp;
        Object response;
        if (obj == null) {
            response = NULL_RESPONSE;
        } else {
            Throwable error = BasicInvocation.getError(obj);
            if (error != null) {
                if (error instanceof CallTimeoutException) {
                    response = RETRY_RESPONSE;
                    if (this.logger.isFinestEnabled()) {
                        this.logger.finest("Call timed-out during wait-notify phase, retrying call: " + this.toString());
                    }
                    if (this.op instanceof WaitSupport) {
                        long waitTimeout = this.op.getWaitTimeout();
                        this.op.setWaitTimeout(waitTimeout -= this.callTimeout);
                    }
                    --this.invokeCount;
                } else {
                    ExceptionAction action = this.onException(error);
                    int localInvokeCount = this.invokeCount;
                    if (action == ExceptionAction.RETRY_INVOCATION && localInvokeCount < this.tryCount) {
                        response = RETRY_RESPONSE;
                        if (localInvokeCount > 99 && localInvokeCount % 10 == 0) {
                            this.logger.warning("Retrying invocation: " + this.toString() + ", Reason: " + error);
                        }
                    } else {
                        response = action == ExceptionAction.CONTINUE_WAIT ? WAIT_RESPONSE : error;
                    }
                }
            } else {
                response = obj;
            }
        }
        if (response == RETRY_RESPONSE) {
            if (this.invocationFuture.interrupted) {
                this.invocationFuture.set(INTERRUPTED_RESPONSE);
            } else {
                this.invocationFuture.set(WAIT_RESPONSE);
                ExecutionService ex = this.nodeEngine.getExecutionService();
                if (this.invokeCount < 5) {
                    this.getAsyncExecutor().execute(new ReInvocationTask());
                } else {
                    ex.schedule("hz:async", new ReInvocationTask(), this.tryPauseMillis, TimeUnit.MILLISECONDS);
                }
            }
            return;
        }
        if (response == WAIT_RESPONSE) {
            this.invocationFuture.set(WAIT_RESPONSE);
            return;
        }
        if (response instanceof NormalResponse && this.op instanceof BackupAwareOperation && (resp = (NormalResponse)response).getBackupCount() > 0) {
            this.waitForBackups(resp.getBackupCount(), 5L, TimeUnit.SECONDS, resp);
            return;
        }
        this.invocationFuture.set(response);
    }

    private void doInvoke() {
        Address invTarget;
        if (!this.nodeEngine.isActive()) {
            this.remote = false;
            this.notify(new HazelcastInstanceNotActiveException());
            return;
        }
        this.target = invTarget = this.getTarget();
        ++this.invokeCount;
        Address thisAddress = this.nodeEngine.getThisAddress();
        if (invTarget == null) {
            this.remote = false;
            if (this.nodeEngine.isActive()) {
                this.notify(new WrongTargetException(thisAddress, null, this.partitionId, this.replicaIndex, this.op.getClass().getName(), this.serviceName));
            } else {
                this.notify(new HazelcastInstanceNotActiveException());
            }
            return;
        }
        MemberImpl member = this.nodeEngine.getClusterService().getMember(invTarget);
        if (!OperationAccessor.isJoinOperation(this.op) && member == null) {
            this.notify(new TargetNotMemberException(invTarget, this.partitionId, this.op.getClass().getName(), this.serviceName));
            return;
        }
        if (this.op.getPartitionId() != this.partitionId) {
            this.notify(new IllegalStateException("Partition id of operation: " + this.op.getPartitionId() + " is not equal to the partition id of invocation: " + this.partitionId));
            return;
        }
        if (this.op.getReplicaIndex() != this.replicaIndex) {
            this.notify(new IllegalStateException("Replica index of operation: " + this.op.getReplicaIndex() + " is not equal to the replica index of invocation: " + this.replicaIndex));
            return;
        }
        BasicOperationService operationService = (BasicOperationService)this.nodeEngine.operationService;
        OperationAccessor.setInvocationTime(this.op, this.nodeEngine.getClusterTime());
        boolean bl = this.remote = !thisAddress.equals(invTarget);
        if (this.remote) {
            RemoteCall call = member != null ? new RemoteCall(member, (Callback<Object>)this) : new RemoteCall(invTarget, (Callback<Object>)this);
            long callId = operationService.registerRemoteCall(call);
            if (this.op instanceof BackupAwareOperation) {
                this.registerBackups((BackupAwareOperation)((Object)this.op), callId);
            }
            OperationAccessor.setCallId(this.op, callId);
            boolean sent = operationService.send(this.op, invTarget);
            if (!sent) {
                operationService.deregisterRemoteCall(callId);
                operationService.deregisterBackupCall(callId);
                this.notify(new RetryableIOException("Packet not sent to -> " + invTarget));
            }
        } else {
            if (this.op instanceof BackupAwareOperation) {
                long callId = operationService.newCallId();
                this.registerBackups((BackupAwareOperation)((Object)this.op), callId);
                OperationAccessor.setCallId(this.op, callId);
            }
            ResponseHandlerFactory.setLocalResponseHandler(this.op, this);
            if (operationService.isAllowedToRunInCurrentThread(this.op)) {
                operationService.runOperation(this.op);
            } else {
                operationService.executeOperation(this.op);
            }
        }
    }

    protected abstract Address getTarget();

    private void registerBackups(BackupAwareOperation op, long callId) {
        long oldCallId = ((Operation)((Object)op)).getCallId();
        BasicOperationService operationService = (BasicOperationService)this.nodeEngine.operationService;
        if (oldCallId != 0L) {
            operationService.deregisterBackupCall(oldCallId);
        }
        operationService.registerBackupCall(callId, this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BasicInvocation");
        sb.append("{ serviceName='").append(this.serviceName).append('\'');
        sb.append(", op=").append(this.op);
        sb.append(", partitionId=").append(this.partitionId);
        sb.append(", replicaIndex=").append(this.replicaIndex);
        sb.append(", tryCount=").append(this.tryCount);
        sb.append(", tryPauseMillis=").append(this.tryPauseMillis);
        sb.append(", invokeCount=").append(this.invokeCount);
        sb.append(", callTimeout=").append(this.callTimeout);
        sb.append(", target=").append(this.target);
        sb.append('}');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalOneBackupComplete() {
        BasicInvocation basicInvocation = this;
        synchronized (basicInvocation) {
            ++this.availableBackups;
            if (this.expectedBackupCount == -1) {
                return;
            }
            if (this.expectedBackupCount != this.availableBackups) {
                return;
            }
            if (this.potentialResponse != null) {
                this.invocationFuture.set(this.potentialResponse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBackups(int backupCount, long timeout, TimeUnit unit, NormalResponse response) {
        BasicInvocation basicInvocation = this;
        synchronized (basicInvocation) {
            this.expectedBackupCount = backupCount;
            if (this.availableBackups == this.expectedBackupCount) {
                this.invocationFuture.set(response);
                return;
            }
            this.potentialResponse = response;
        }
        this.nodeEngine.getExecutionService().schedule("hz:async", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BasicInvocation basicInvocation = BasicInvocation.this;
                synchronized (basicInvocation) {
                    if (BasicInvocation.this.expectedBackupCount == BasicInvocation.this.availableBackups) {
                        return;
                    }
                }
                if (BasicInvocation.this.nodeEngine.getClusterService().getMember(BasicInvocation.this.target) != null) {
                    basicInvocation = BasicInvocation.this;
                    synchronized (basicInvocation) {
                        if (BasicInvocation.this.potentialResponse != null) {
                            BasicInvocation.this.invocationFuture.set(BasicInvocation.this.potentialResponse);
                            BasicInvocation.this.potentialResponse = null;
                        }
                    }
                    return;
                }
                BasicInvocation.this.resetAndReInvoke();
            }
        }, timeout, unit);
    }

    private static class InternalResponse {
        String toString;

        private InternalResponse(String toString) {
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }
    }

    private final class InvocationFuture<E>
    implements InternalCompletableFuture<E> {
        volatile ExecutionCallbackNode<E> callbackHead;
        volatile Object response;
        volatile boolean interrupted = false;

        private InvocationFuture(Callback<E> callback) {
            if (callback != null) {
                ExecutorCallbackAdapter adapter = new ExecutorCallbackAdapter(callback);
                this.callbackHead = new ExecutionCallbackNode(adapter, BasicInvocation.this.getAsyncExecutor(), null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void andThen(ExecutionCallback<E> callback, Executor executor) {
            ValidationUtil.isNotNull(callback, "callback");
            ValidationUtil.isNotNull(executor, "executor");
            InvocationFuture invocationFuture = this;
            synchronized (invocationFuture) {
                if (this.response != null) {
                    this.runAsynchronous(callback, executor);
                    return;
                }
                this.callbackHead = new ExecutionCallbackNode(callback, executor, this.callbackHead);
            }
        }

        @Override
        public void andThen(ExecutionCallback<E> callback) {
            this.andThen(callback, (Executor)BasicInvocation.this.getAsyncExecutor());
        }

        private void runAsynchronous(final ExecutionCallback<E> callback, Executor executor) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object resp = InvocationFuture.this.resolveResponse(InvocationFuture.this.response);
                        if (resp == null || !(resp instanceof Throwable)) {
                            callback.onResponse(resp);
                        } else {
                            callback.onFailure((Throwable)resp);
                        }
                    }
                    catch (Throwable t) {
                        BasicInvocation.this.logger.severe("Failed to async for " + BasicInvocation.this, t);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(Object response) {
            ExecutionCallbackNode callbackChain;
            if (response == null) {
                throw new IllegalArgumentException("response can't be null");
            }
            if (response instanceof NormalResponse) {
                response = ((NormalResponse)response).getValue();
            }
            if (response == null) {
                response = NULL_RESPONSE;
            }
            InvocationFuture invocationFuture = this;
            synchronized (invocationFuture) {
                if (this.response != null && !(this.response instanceof InternalResponse)) {
                    throw new IllegalArgumentException("The InvocationFuture.set method can only be called once");
                }
                this.response = response;
                if (response == WAIT_RESPONSE) {
                    return;
                }
                callbackChain = this.callbackHead;
                this.callbackHead = null;
                this.notifyAll();
            }
            BasicOperationService operationService = (BasicOperationService)BasicInvocation.this.nodeEngine.operationService;
            operationService.deregisterBackupCall(BasicInvocation.this.op.getCallId());
            while (callbackChain != null) {
                this.runAsynchronous(callbackChain.callback, callbackChain.executor);
                callbackChain = callbackChain.next;
            }
        }

        @Override
        public E get() throws InterruptedException, ExecutionException {
            try {
                return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                BasicInvocation.this.logger.severe("Unexpected timeout while processing " + this, e);
                return null;
            }
        }

        @Override
        public E getSafely() {
            try {
                return this.get();
            }
            catch (Throwable throwable) {
                throw ExceptionUtil.rethrow(throwable);
            }
        }

        @Override
        public E get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Object unresolvedResponse = this.waitForResponse(timeout, unit);
            return (E)this.resolveResponseOrThrowException(unresolvedResponse);
        }

        private Object waitForResponse(long time, TimeUnit unit) {
            if (this.response != null && this.response != WAIT_RESPONSE) {
                return this.response;
            }
            long timeoutMs = unit.toMillis(time);
            if (timeoutMs < 0L) {
                timeoutMs = 0L;
            }
            long maxCallTimeout = BasicInvocation.this.callTimeout * 2L > 0L ? BasicInvocation.this.callTimeout * 2L : Long.MAX_VALUE;
            boolean longPolling = timeoutMs > maxCallTimeout;
            int pollCount = 0;
            while (timeoutMs >= 0L) {
                long pollTimeoutMs = Math.min(maxCallTimeout, timeoutMs);
                long startMs = Clock.currentTimeMillis();
                long lastPollTime = 0L;
                ++pollCount;
                try {
                    this.pollResponse(pollTimeoutMs);
                    lastPollTime = Clock.currentTimeMillis() - startMs;
                    timeoutMs = BasicInvocation.decrementTimeout(timeoutMs, lastPollTime);
                    if (this.response != null) {
                        if (this.response == WAIT_RESPONSE) continue;
                        if (this.response != INTERRUPTED_RESPONSE && this.interrupted) {
                            Thread.currentThread().interrupt();
                        }
                        return this.response;
                    }
                }
                catch (InterruptedException e) {
                    this.interrupted = true;
                }
                if (this.interrupted || !longPolling) continue;
                Address target = BasicInvocation.this.getTarget();
                if (BasicInvocation.this.nodeEngine.getThisAddress().equals(target)) continue;
                BasicInvocation.this.logger.warning("No response for " + lastPollTime + " ms. " + this.toString());
                boolean executing = this.isOperationExecuting(target);
                if (executing || this.response != null) continue;
                return this.newOperationTimeoutException(pollCount, pollTimeoutMs);
            }
            return TIMEOUT_RESPONSE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pollResponse(long pollTimeoutMs) throws InterruptedException {
            if (pollTimeoutMs > 0L) {
                long currentTimeoutMs = pollTimeoutMs;
                long waitStart = Clock.currentTimeMillis();
                InvocationFuture invocationFuture = this;
                synchronized (invocationFuture) {
                    while (currentTimeoutMs > 0L && (this.response == null || this.response == WAIT_RESPONSE)) {
                        this.wait(currentTimeoutMs);
                        currentTimeoutMs = pollTimeoutMs - (Clock.currentTimeMillis() - waitStart);
                    }
                }
            }
        }

        private Object newOperationTimeoutException(int pollCount, long pollTimeoutMs) {
            boolean hasResponse = BasicInvocation.this.potentialResponse != null;
            int backupsExpected = BasicInvocation.this.expectedBackupCount;
            int backupsCompleted = BasicInvocation.this.availableBackups;
            if (hasResponse) {
                return new OperationTimeoutException("No response for " + pollTimeoutMs * (long)pollCount + " ms." + " Aborting invocation! " + this.toString() + " Not all backups have completed " + " backups-expected: " + backupsExpected + " backups-completed: " + backupsCompleted + " reinvocations: " + BasicInvocation.this.reinvocations);
            }
            return new OperationTimeoutException("No response for " + pollTimeoutMs * (long)pollCount + " ms." + " Aborting invocation! " + this.toString() + " No response has been send " + " backups-expected: " + backupsExpected + " backups-completed: " + backupsCompleted + " reinvocations: " + BasicInvocation.this.reinvocations);
        }

        private Object resolveResponseOrThrowException(Object unresolvedResponse) throws ExecutionException, InterruptedException, TimeoutException {
            Object response = this.resolveResponse(unresolvedResponse);
            if (response == null || !(response instanceof Throwable)) {
                return response;
            }
            if (response instanceof ExecutionException) {
                throw (ExecutionException)response;
            }
            if (response instanceof TimeoutException) {
                throw (TimeoutException)response;
            }
            if (response instanceof InterruptedException) {
                throw (InterruptedException)response;
            }
            if (response instanceof Error) {
                throw (Error)response;
            }
            throw new ExecutionException((Throwable)response);
        }

        private Object resolveResponse(Object unresolvedResponse) {
            if (unresolvedResponse == NULL_RESPONSE) {
                return null;
            }
            if (unresolvedResponse == TIMEOUT_RESPONSE) {
                return new TimeoutException("Call " + BasicInvocation.this + " encountered a timeout");
            }
            if (unresolvedResponse == INTERRUPTED_RESPONSE) {
                return new InterruptedException("Call " + BasicInvocation.this + " was interrupted");
            }
            Object response = unresolvedResponse;
            if (BasicInvocation.this.resultDeserialized && response instanceof Data && (response = BasicInvocation.this.nodeEngine.toObject(response)) == null) {
                return null;
            }
            if (response instanceof NormalResponse) {
                NormalResponse responseObj = (NormalResponse)response;
                if ((response = responseObj.getValue()) == null) {
                    return null;
                }
                if (BasicInvocation.this.resultDeserialized && response instanceof Data && (response = BasicInvocation.this.nodeEngine.toObject(response)) == null) {
                    return null;
                }
            }
            if (response instanceof Throwable) {
                Throwable throwable = (Throwable)response;
                if (BasicInvocation.this.remote) {
                    ExceptionUtil.fixRemoteStackTrace((Throwable)response, Thread.currentThread().getStackTrace());
                }
                return throwable;
            }
            return response;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.response != null;
        }

        private boolean isOperationExecuting(Address target) {
            Boolean executing = Boolean.FALSE;
            try {
                AbstractOperation isStillExecuting;
                if (BasicInvocation.this.op instanceof TraceableOperation) {
                    TraceableOperation traceable = (TraceableOperation)((Object)BasicInvocation.this.op);
                    isStillExecuting = new TraceableIsStillExecuting(BasicInvocation.this.serviceName, traceable.getTraceIdentifier());
                } else {
                    isStillExecuting = new IsStillExecuting(BasicInvocation.this.op.getCallId());
                }
                BasicTargetInvocation inv = new BasicTargetInvocation(BasicInvocation.this.nodeEngine, BasicInvocation.this.serviceName, isStillExecuting, target, 0, 0L, 5000L, null, null, true);
                InvocationFuture f = inv.invoke();
                BasicInvocation.this.logger.warning("Asking if operation execution has been started: " + this.toString());
                executing = (Boolean)BasicInvocation.this.nodeEngine.toObject(f.get(5000L, TimeUnit.MILLISECONDS));
            }
            catch (Exception e) {
                BasicInvocation.this.logger.warning("While asking 'is-executing': " + this.toString(), e);
            }
            BasicInvocation.this.logger.warning("'is-executing': " + executing + " -> " + this.toString());
            return executing;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("InvocationFuture{");
            sb.append("invocation=").append(BasicInvocation.this.toString());
            sb.append(", done=").append(this.isDone());
            sb.append('}');
            return sb.toString();
        }
    }

    private static class ExecutorCallbackAdapter<E>
    implements ExecutionCallback<E> {
        private final Callback callback;

        private ExecutorCallbackAdapter(Callback callback) {
            this.callback = callback;
        }

        @Override
        public void onResponse(E response) {
            this.callback.notify(response);
        }

        @Override
        public void onFailure(Throwable t) {
            this.callback.notify(t);
        }
    }

    private static class ExecutionCallbackNode<E> {
        private final ExecutionCallback<E> callback;
        private final Executor executor;
        private final ExecutionCallbackNode<E> next;

        private ExecutionCallbackNode(ExecutionCallback<E> callback, Executor executor, ExecutionCallbackNode<E> next) {
            this.callback = callback;
            this.executor = executor;
            this.next = next;
        }
    }

    private class ReInvocationTask
    implements Runnable {
        private ReInvocationTask() {
        }

        @Override
        public void run() {
            BasicInvocation.this.doInvoke();
        }
    }

    public static class TraceableIsStillExecuting
    extends AbstractOperation {
        private String serviceName;
        private Object identifier;

        TraceableIsStillExecuting() {
        }

        public TraceableIsStillExecuting(String serviceName, Object identifier) {
            this.serviceName = serviceName;
            this.identifier = identifier;
        }

        @Override
        public void run() throws Exception {
            NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
            BasicOperationService operationService = (BasicOperationService)nodeEngine.operationService;
            boolean executing = operationService.isOperationExecuting(this.getCallerAddress(), this.getCallerUuid(), this.serviceName, this.identifier);
            this.getResponseHandler().sendResponse(executing);
        }

        @Override
        public boolean returnsResponse() {
            return false;
        }

        @Override
        protected void readInternal(ObjectDataInput in) throws IOException {
            super.readInternal(in);
            this.serviceName = in.readUTF();
            this.identifier = in.readObject();
        }

        @Override
        protected void writeInternal(ObjectDataOutput out) throws IOException {
            super.writeInternal(out);
            out.writeUTF(this.serviceName);
            out.writeObject(this.identifier);
        }
    }

    public static class IsStillExecuting
    extends AbstractOperation {
        private long operationCallId;

        IsStillExecuting() {
        }

        private IsStillExecuting(long operationCallId) {
            this.operationCallId = operationCallId;
        }

        @Override
        public void run() throws Exception {
            NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
            BasicOperationService operationService = (BasicOperationService)nodeEngine.operationService;
            boolean executing = operationService.isOperationExecuting(this.getCallerAddress(), this.getCallerUuid(), this.operationCallId);
            this.getResponseHandler().sendResponse(executing);
        }

        @Override
        public boolean returnsResponse() {
            return false;
        }

        @Override
        protected void readInternal(ObjectDataInput in) throws IOException {
            super.readInternal(in);
            this.operationCallId = in.readLong();
        }

        @Override
        protected void writeInternal(ObjectDataOutput out) throws IOException {
            super.writeInternal(out);
            out.writeLong(this.operationCallId);
        }
    }
}

