/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.txn;

import com.hazelcast.collection.CollectionBackupAwareOperation;
import com.hazelcast.collection.CollectionDataSerializerHook;
import com.hazelcast.collection.txn.CollectionRollbackBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class CollectionRollbackOperation
extends CollectionBackupAwareOperation {
    private long itemId;
    private boolean removeOperation;

    public CollectionRollbackOperation() {
    }

    public CollectionRollbackOperation(String name, long itemId, boolean removeOperation) {
        super(name);
        this.itemId = itemId;
        this.removeOperation = removeOperation;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return new CollectionRollbackBackupOperation(this.name, this.itemId, this.removeOperation);
    }

    @Override
    public int getId() {
        return CollectionDataSerializerHook.COLLECTION_ROLLBACK;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        if (this.removeOperation) {
            this.getOrCreateContainer().rollbackRemove(this.itemId);
        } else {
            this.getOrCreateContainer().rollbackAdd(this.itemId);
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.itemId);
        out.writeBoolean(this.removeOperation);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemId = in.readLong();
        this.removeOperation = in.readBoolean();
    }
}

